rule win_blindingcan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.blindingcan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blindingcan"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7459c52b86f28 c745a0b5c9a315 c745a453e8ba52 c745a8b67dbc8f }
            // n = 4, score = 300
            //   c7459c52b86f28       | mov                 dword ptr [ebp - 0x64], 0x286fb852
            //   c745a0b5c9a315       | mov                 dword ptr [ebp - 0x60], 0x15a3c9b5
            //   c745a453e8ba52       | mov                 dword ptr [ebp - 0x5c], 0x52bae853
            //   c745a8b67dbc8f       | mov                 dword ptr [ebp - 0x58], 0x8fbc7db6

        $sequence_1 = { c745c091810345 c745c401761a06 c745c859c24b75 c745ccec723768 c745d01a51c3d9 c745d46744180d }
            // n = 6, score = 300
            //   c745c091810345       | mov                 dword ptr [ebp - 0x40], 0x45038191
            //   c745c401761a06       | mov                 dword ptr [ebp - 0x3c], 0x61a7601
            //   c745c859c24b75       | mov                 dword ptr [ebp - 0x38], 0x754bc259
            //   c745ccec723768       | mov                 dword ptr [ebp - 0x34], 0x683772ec
            //   c745d01a51c3d9       | mov                 dword ptr [ebp - 0x30], 0xd9c3511a
            //   c745d46744180d       | mov                 dword ptr [ebp - 0x2c], 0xd184467

        $sequence_2 = { c745f0a70d9fae c745f48f2aedf1 c745f8fee389dd e8???????? }
            // n = 4, score = 300
            //   c745f0a70d9fae       | mov                 dword ptr [ebp - 0x10], 0xae9f0da7
            //   c745f48f2aedf1       | mov                 dword ptr [ebp - 0xc], 0xf1ed2a8f
            //   c745f8fee389dd       | mov                 dword ptr [ebp - 8], 0xdd89e3fe
            //   e8????????           |                     

        $sequence_3 = { 8bca 8db5fcfeffff 8dbdfcfdffff f3a5 68b80b0000 8bfa }
            // n = 6, score = 300
            //   8bca                 | mov                 ecx, edx
            //   8db5fcfeffff         | lea                 esi, [ebp - 0x104]
            //   8dbdfcfdffff         | lea                 edi, [ebp - 0x204]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   68b80b0000           | push                0xbb8
            //   8bfa                 | mov                 edi, edx

        $sequence_4 = { c78560fdffffdd2edf9c c78564fdffffbaced582 c78568fdffff9ffa2924 c7856cfdfffff0888168 c78570fdffff48b96edc }
            // n = 5, score = 300
            //   c78560fdffffdd2edf9c     | mov    dword ptr [ebp - 0x2a0], 0x9cdf2edd
            //   c78564fdffffbaced582     | mov    dword ptr [ebp - 0x29c], 0x82d5ceba
            //   c78568fdffff9ffa2924     | mov    dword ptr [ebp - 0x298], 0x2429fa9f
            //   c7856cfdfffff0888168     | mov    dword ptr [ebp - 0x294], 0x688188f0
            //   c78570fdffff48b96edc     | mov    dword ptr [ebp - 0x290], 0xdc6eb948

        $sequence_5 = { c785d8feffffcbdb9298 c785dcfeffff85b369f5 c785e0feffffe981ae61 c785e4feffff2f30fbf4 c785e8feffff3d4fab62 c785ecfeffff9c1c9a02 }
            // n = 6, score = 300
            //   c785d8feffffcbdb9298     | mov    dword ptr [ebp - 0x128], 0x9892dbcb
            //   c785dcfeffff85b369f5     | mov    dword ptr [ebp - 0x124], 0xf569b385
            //   c785e0feffffe981ae61     | mov    dword ptr [ebp - 0x120], 0x61ae81e9
            //   c785e4feffff2f30fbf4     | mov    dword ptr [ebp - 0x11c], 0xf4fb302f
            //   c785e8feffff3d4fab62     | mov    dword ptr [ebp - 0x118], 0x62ab4f3d
            //   c785ecfeffff9c1c9a02     | mov    dword ptr [ebp - 0x114], 0x29a1c9c

        $sequence_6 = { c78558fdffff850d28e7 c7855cfdffffd50f3950 c78560fdffffdd2edf9c c78564fdffffbaced582 }
            // n = 4, score = 300
            //   c78558fdffff850d28e7     | mov    dword ptr [ebp - 0x2a8], 0xe7280d85
            //   c7855cfdffffd50f3950     | mov    dword ptr [ebp - 0x2a4], 0x50390fd5
            //   c78560fdffffdd2edf9c     | mov    dword ptr [ebp - 0x2a0], 0x9cdf2edd
            //   c78564fdffffbaced582     | mov    dword ptr [ebp - 0x29c], 0x82d5ceba

        $sequence_7 = { 8bc1 99 f7fb 888c0dfcfeffff }
            // n = 4, score = 300
            //   8bc1                 | mov                 eax, ecx
            //   99                   | cdq                 
            //   f7fb                 | idiv                ebx
            //   888c0dfcfeffff       | mov                 byte ptr [ebp + ecx - 0x104], cl

        $sequence_8 = { f7fe 8bca e8???????? 85c0 7409 e8???????? }
            // n = 6, score = 200
            //   f7fe                 | idiv                esi
            //   8bca                 | mov                 ecx, edx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   e8????????           |                     

        $sequence_9 = { 48895c2408 4889742410 57 4883ec20 488d057e910100 488bda 488bf9 }
            // n = 7, score = 100
            //   48895c2408           | dec                 eax
            //   4889742410           | inc                 dword ptr [eax]
            //   57                   | dec                 eax
            //   4883ec20             | lea                 ecx, [esp + 0x7c]
            //   488d057e910100       | mov                 edx, 0x200
            //   488bda               | dec                 eax
            //   488bf9               | mov                 ebx, ecx

        $sequence_10 = { f644245010 0f849f000000 488b442438 488b4c2430 48ff00 ff15???????? 488d4c247c }
            // n = 7, score = 100
            //   f644245010           | inc                 edx
            //   0f849f000000         | lea                 eax, [edi]
            //   488b442438           | cmp                 eax, 0x10000
            //   488b4c2430           | jle                 0x6e
            //   48ff00               | mov                 ecx, 0x2018
            //   ff15????????         |                     
            //   488d4c247c           | inc                 ebp

        $sequence_11 = { 744b 48391d???????? 7442 ff15???????? 85c0 7438 488b0d???????? }
            // n = 7, score = 100
            //   744b                 | je                  0x4d
            //   48391d????????       |                     
            //   7442                 | je                  0x44
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7438                 | je                  0x3a
            //   488b0d????????       |                     

        $sequence_12 = { 7403 c60701 ffc3 4983c404 4883c608 48ffc7 83fb1a }
            // n = 7, score = 100
            //   7403                 | mov                 ecx, eax
            //   c60701               | test                eax, eax
            //   ffc3                 | je                  5
            //   4983c404             | mov                 byte ptr [edi], 1
            //   4883c608             | inc                 ebx
            //   48ffc7               | dec                 ecx
            //   83fb1a               | add                 esp, 4

        $sequence_13 = { ba00020000 488bd9 c745e745f0c989 c745eb66772976 c745ef70a9e4c4 c745f3d39c157b c745f7c10df5f5 }
            // n = 7, score = 100
            //   ba00020000           | xor                 ecx, ecx
            //   488bd9               | test                byte ptr [esp + 0x50], 0x10
            //   c745e745f0c989       | je                  0xa5
            //   c745eb66772976       | dec                 eax
            //   c745ef70a9e4c4       | mov                 eax, dword ptr [esp + 0x38]
            //   c745f3d39c157b       | dec                 eax
            //   c745f7c10df5f5       | mov                 ecx, dword ptr [esp + 0x30]

        $sequence_14 = { ff15???????? 4885c0 7434 33d2 488bc8 ff15???????? 85c0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   4885c0               | dec                 eax
            //   7434                 | test                eax, eax
            //   33d2                 | je                  0x36
            //   488bc8               | xor                 edx, edx
            //   ff15????????         |                     
            //   85c0                 | dec                 eax

        $sequence_15 = { 8d7c001e 428d0427 3d00000100 7e6c 488b15???????? b918200000 4533c9 }
            // n = 7, score = 100
            //   8d7c001e             | dec                 eax
            //   428d0427             | add                 esi, 8
            //   3d00000100           | dec                 eax
            //   7e6c                 | inc                 edi
            //   488b15????????       |                     
            //   b918200000           | cmp                 ebx, 0x1a
            //   4533c9               | lea                 edi, [eax + eax + 0x1e]

    condition:
        7 of them and filesize < 363520
}