rule win_blister_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.blister."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blister"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745e8ca000000 c745f0cb000000 e8???????? 83c41c 3bc6 7414 ff7308 }
            // n = 7, score = 100
            //   c745e8ca000000       | mov                 dword ptr [ebp - 0x18], 0xca
            //   c745f0cb000000       | mov                 dword ptr [ebp - 0x10], 0xcb
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   3bc6                 | cmp                 eax, esi
            //   7414                 | je                  0x16
            //   ff7308               | push                dword ptr [ebx + 8]

        $sequence_1 = { e8???????? 8d45fc 50 8bcf e8???????? 85c0 7ce2 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7ce2                 | jl                  0xffffffe4

        $sequence_2 = { 8bc8 e8???????? 8bd8 85db 0f8ca5000000 6a04 e8???????? }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   0f8ca5000000         | jl                  0xab
            //   6a04                 | push                4
            //   e8????????           |                     

        $sequence_3 = { c1e910 33d2 663bd1 7513 52 52 e8???????? }
            // n = 7, score = 100
            //   c1e910               | shr                 ecx, 0x10
            //   33d2                 | xor                 edx, edx
            //   663bd1               | cmp                 dx, cx
            //   7513                 | jne                 0x15
            //   52                   | push                edx
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_4 = { 83f901 7f40 57 e8???????? 03de 33c9 6a02 }
            // n = 7, score = 100
            //   83f901               | cmp                 ecx, 1
            //   7f40                 | jg                  0x42
            //   57                   | push                edi
            //   e8????????           |                     
            //   03de                 | add                 ebx, esi
            //   33c9                 | xor                 ecx, ecx
            //   6a02                 | push                2

        $sequence_5 = { ff45f4 8b45f4 83c70c 3b45f8 72e3 eb07 c745ec01000000 }
            // n = 7, score = 100
            //   ff45f4               | inc                 dword ptr [ebp - 0xc]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83c70c               | add                 edi, 0xc
            //   3b45f8               | cmp                 eax, dword ptr [ebp - 8]
            //   72e3                 | jb                  0xffffffe5
            //   eb07                 | jmp                 9
            //   c745ec01000000       | mov                 dword ptr [ebp - 0x14], 1

        $sequence_6 = { 7568 8bce e8???????? ebd6 ff7508 8bce }
            // n = 6, score = 100
            //   7568                 | jne                 0x6a
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   ebd6                 | jmp                 0xffffffd8
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8bce                 | mov                 ecx, esi

        $sequence_7 = { 85f6 7c7a 8b8df0ddffff 57 e8???????? 8bf0 85f6 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   7c7a                 | jl                  0x7c
            //   8b8df0ddffff         | mov                 ecx, dword ptr [ebp - 0x2210]
            //   57                   | push                edi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_8 = { 56 ff10 8bf8 85ff 7409 6a01 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   ff10                 | call                dword ptr [eax]
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7409                 | je                  0xb
            //   6a01                 | push                1

        $sequence_9 = { 59 894604 85c0 7503 895dfc 33ff 397dfc }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   85c0                 | test                eax, eax
            //   7503                 | jne                 5
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   33ff                 | xor                 edi, edi
            //   397dfc               | cmp                 dword ptr [ebp - 4], edi

    condition:
        7 of them and filesize < 1822720
}