rule win_boatlaunch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.boatlaunch."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.boatlaunch"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d15a1190000 e8???????? e8???????? 488bd8 4885db 7468 }
            // n = 6, score = 100
            //   488d15a1190000       | dec                 eax
            //   e8????????           |                     
            //   e8????????           |                     
            //   488bd8               | lea                 esp, [ebp + 0x18]
            //   4885db               | inc                 ecx
            //   7468                 | pop                 ebx

        $sequence_1 = { eb05 e9???????? 48837dc800 7412 488b0d???????? 33d2 4c8b45c8 }
            // n = 7, score = 100
            //   eb05                 | push                ebx
            //   e9????????           |                     
            //   48837dc800           | push                ecx
            //   7412                 | jmp                 7
            //   488b0d????????       |                     
            //   33d2                 | dec                 eax
            //   4c8b45c8             | cmp                 dword ptr [ebp - 0x38], 0

        $sequence_2 = { 488b4030 4883c408 c3 4855 4883ec20 488d6c2420 }
            // n = 6, score = 100
            //   488b4030             | pop                 ebx
            //   4883c408             | inc                 ecx
            //   c3                   | pop                 edx
            //   4855                 | inc                 ecx
            //   4883ec20             | pop                 ecx
            //   488d6c2420           | xor                 edx, edx

        $sequence_3 = { 85c0 7501 ab 8bfe }
            // n = 4, score = 100
            //   85c0                 | dec                 eax
            //   7501                 | lea                 esp, [ebp + 8]
            //   ab                   | pop                 edi
            //   8bfe                 | jne                 7

        $sequence_4 = { c745f800000000 8d5ddc c70318000000 c7430400000000 c7430800000000 c7430c00000000 c7431000000000 }
            // n = 7, score = 100
            //   c745f800000000       | dec                 eax
            //   8d5ddc               | sub                 esp, 8
            //   c70318000000         | dec                 eax
            //   c7430400000000       | mov                 ebp, esp
            //   c7430800000000       | dec                 eax
            //   c7430c00000000       | lea                 esi, [0x1e21]
            //   c7431000000000       | dec                 ebx

        $sequence_5 = { 7505 e9???????? 8bf8 6800010000 8d85e0eeffff 50 }
            // n = 6, score = 100
            //   7505                 | push                eax
            //   e9????????           |                     
            //   8bf8                 | dec                 eax
            //   6800010000           | lea                 edx, [0x19a1]
            //   8d85e0eeffff         | dec                 eax
            //   50                   | mov                 ebx, eax

        $sequence_6 = { e8???????? 3dffea2d66 7524 ff7344 e8???????? 3b05???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   3dffea2d66           | dec                 eax
            //   7524                 | test                ebx, ebx
            //   ff7344               | je                  0x70
            //   e8????????           |                     
            //   3b05????????         |                     

        $sequence_7 = { 4489442418 4855 53 51 }
            // n = 4, score = 100
            //   4489442418           | inc                 esp
            //   4855                 | mov                 dword ptr [esp + 0x18], eax
            //   53                   | dec                 eax
            //   51                   | push                ebp

        $sequence_8 = { eb05 4b 85db 75ec }
            // n = 4, score = 100
            //   eb05                 | test                ebx, ebx
            //   4b                   | jne                 0xffffffea
            //   85db                 | dec                 eax
            //   75ec                 | mov                 eax, dword ptr [ebp - 8]

        $sequence_9 = { 8b487c 894de0 ff75e0 6a00 ff35???????? e8???????? }
            // n = 6, score = 100
            //   8b487c               | dec                 eax
            //   894de0               | lodsd               eax, dword ptr [esi]
            //   ff75e0               | dec                 eax
            //   6a00                 | test                eax, eax
            //   ff35????????         |                     
            //   e8????????           |                     

        $sequence_10 = { 56 57 4883ec08 488bec 488d35211e0000 }
            // n = 5, score = 100
            //   56                   | ret                 
            //   57                   | dec                 eax
            //   4883ec08             | push                ebp
            //   488bec               | dec                 eax
            //   488d35211e0000       | sub                 esp, 0x20

        $sequence_11 = { ff75f8 6a00 ff35???????? e8???????? 8945f4 8d45f8 50 }
            // n = 7, score = 100
            //   ff75f8               | je                  0x10
            //   6a00                 | dec                 eax
            //   ff35????????         |                     
            //   e8????????           |                     
            //   8945f4               | mov                 ecx, eax
            //   8d45f8               | push                esi
            //   50                   | push                edi

        $sequence_12 = { 85c0 7425 8d55f7 c70233c0c218 c6420400 6a00 }
            // n = 6, score = 100
            //   85c0                 | mov                 edi, eax
            //   7425                 | push                0x100
            //   8d55f7               | lea                 eax, [ebp - 0x1120]
            //   c70233c0c218         | push                eax
            //   c6420400             | cmp                 eax, 0x662deaff
            //   6a00                 | jne                 0x2b

        $sequence_13 = { 4c8b4500 e8???????? 488b4508 488d6518 415b 415a 4159 }
            // n = 7, score = 100
            //   4c8b4500             | je                  0x19
            //   e8????????           |                     
            //   488b4508             | xor                 edx, edx
            //   488d6518             | dec                 esp
            //   415b                 | mov                 eax, dword ptr [ebp - 0x38]
            //   415a                 | dec                 esp
            //   4159                 | mov                 eax, dword ptr [ebp]

        $sequence_14 = { 52 56 57 4150 }
            // n = 4, score = 100
            //   52                   | dec                 esp
            //   56                   | mov                 eax, dword ptr [ebp]
            //   57                   | dec                 eax
            //   4150                 | mov                 eax, dword ptr [ebp + 8]

        $sequence_15 = { 48ad 4885c0 740e 488bc8 e8???????? }
            // n = 5, score = 100
            //   48ad                 | dec                 eax
            //   4885c0               | mov                 eax, dword ptr [eax + 0x30]
            //   740e                 | dec                 eax
            //   488bc8               | add                 esp, 8
            //   e8????????           |                     

    condition:
        7 of them and filesize < 33792
}