rule win_bohmini_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bohmini."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bohmini"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 751e 8b4610 85c0 7403 50 ffd3 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   751e                 | jne                 0x20
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   50                   | push                eax
            //   ffd3                 | call                ebx

        $sequence_1 = { 6a01 ffd5 5f 5e 5d 5b }
            // n = 6, score = 100
            //   6a01                 | push                1
            //   ffd5                 | call                ebp
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx

        $sequence_2 = { 57 ff15???????? 8b742414 57 56 e8???????? 83c408 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b742414             | mov                 esi, dword ptr [esp + 0x14]
            //   57                   | push                edi
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_3 = { 3db7000000 7504 895c240c 8b15???????? }
            // n = 4, score = 100
            //   3db7000000           | cmp                 eax, 0xb7
            //   7504                 | jne                 6
            //   895c240c             | mov                 dword ptr [esp + 0xc], ebx
            //   8b15????????         |                     

        $sequence_4 = { ff15???????? 83f801 7562 8d4c2418 51 e8???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   83f801               | cmp                 eax, 1
            //   7562                 | jne                 0x64
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_5 = { 8b4c2404 85c0 7408 8bc8 8b00 }
            // n = 5, score = 100
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]
            //   85c0                 | test                eax, eax
            //   7408                 | je                  0xa
            //   8bc8                 | mov                 ecx, eax
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_6 = { 50 6819000200 66a5 8d4c2420 55 bf04010000 51 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   6819000200           | push                0x20019
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   55                   | push                ebp
            //   bf04010000           | mov                 edi, 0x104
            //   51                   | push                ecx

        $sequence_7 = { 688b130000 ff15???????? 8b7c2410 e9???????? 53 56 55 }
            // n = 7, score = 100
            //   688b130000           | push                0x138b
            //   ff15????????         |                     
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   e9????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   55                   | push                ebp

        $sequence_8 = { 6a00 50 8b84244c010000 50 e8???????? }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8b84244c010000       | mov                 eax, dword ptr [esp + 0x14c]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_9 = { 8b8c2458020000 8d54244c 51 52 e8???????? 83c408 }
            // n = 6, score = 100
            //   8b8c2458020000       | mov                 ecx, dword ptr [esp + 0x258]
            //   8d54244c             | lea                 edx, [esp + 0x4c]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

    condition:
        7 of them and filesize < 139264
}