rule win_bolek_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bolek."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bolek"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd3 8b45d8 83c40c 0345fc ff75dc ff75f8 50 }
            // n = 7, score = 600
            //   ffd3                 | call                ebx
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   83c40c               | add                 esp, 0xc
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   50                   | push                eax

        $sequence_1 = { 8945ec 85db 744e 48 83c624 f7d0 03fe }
            // n = 7, score = 600
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   85db                 | test                ebx, ebx
            //   744e                 | je                  0x50
            //   48                   | dec                 eax
            //   83c624               | add                 esi, 0x24
            //   f7d0                 | not                 eax
            //   03fe                 | add                 edi, esi

        $sequence_2 = { eb16 8bc7 8bce c1e110 c1e810 03c1 8d4a01 }
            // n = 7, score = 600
            //   eb16                 | jmp                 0x18
            //   8bc7                 | mov                 eax, edi
            //   8bce                 | mov                 ecx, esi
            //   c1e110               | shl                 ecx, 0x10
            //   c1e810               | shr                 eax, 0x10
            //   03c1                 | add                 eax, ecx
            //   8d4a01               | lea                 ecx, [edx + 1]

        $sequence_3 = { e8???????? 83c41c ff75f8 ff15???????? 50 ff15???????? 8b4520 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4520               | mov                 eax, dword ptr [ebp + 0x20]

        $sequence_4 = { ff760c e8???????? ff760c e8???????? ff7610 e8???????? 837e1400 }
            // n = 7, score = 600
            //   ff760c               | push                dword ptr [esi + 0xc]
            //   e8????????           |                     
            //   ff760c               | push                dword ptr [esi + 0xc]
            //   e8????????           |                     
            //   ff7610               | push                dword ptr [esi + 0x10]
            //   e8????????           |                     
            //   837e1400             | cmp                 dword ptr [esi + 0x14], 0

        $sequence_5 = { 85c0 0f8432020000 8b75f0 85f6 0f8427020000 56 6a04 }
            // n = 7, score = 600
            //   85c0                 | test                eax, eax
            //   0f8432020000         | je                  0x238
            //   8b75f0               | mov                 esi, dword ptr [ebp - 0x10]
            //   85f6                 | test                esi, esi
            //   0f8427020000         | je                  0x22d
            //   56                   | push                esi
            //   6a04                 | push                4

        $sequence_6 = { 85c0 7e06 03d8 2bf8 75ea 85ff 751a }
            // n = 7, score = 600
            //   85c0                 | test                eax, eax
            //   7e06                 | jle                 8
            //   03d8                 | add                 ebx, eax
            //   2bf8                 | sub                 edi, eax
            //   75ea                 | jne                 0xffffffec
            //   85ff                 | test                edi, edi
            //   751a                 | jne                 0x1c

        $sequence_7 = { ff7610 896c242c 894c2428 e8???????? 83c418 85c0 0f8882000000 }
            // n = 7, score = 600
            //   ff7610               | push                dword ptr [esi + 0x10]
            //   896c242c             | mov                 dword ptr [esp + 0x2c], ebp
            //   894c2428             | mov                 dword ptr [esp + 0x28], ecx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   0f8882000000         | js                  0x88

        $sequence_8 = { 8955ec 33c9 8945e8 51 50 51 51 }
            // n = 7, score = 600
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   33c9                 | xor                 ecx, ecx
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   51                   | push                ecx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   51                   | push                ecx

        $sequence_9 = { ff742428 6810270000 57 55 53 e8???????? 8bd0 }
            // n = 7, score = 600
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   6810270000           | push                0x2710
            //   57                   | push                edi
            //   55                   | push                ebp
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax

    condition:
        7 of them and filesize < 892928
}