rule win_broomstick_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.broomstick."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.broomstick"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7471400000000 8b5610 8b4b10 8955f0 894dec 8d0411 8945f8 }
            // n = 7, score = 1900
            //   c7471400000000       | mov                 dword ptr [edi + 0x14], 0
            //   8b5610               | mov                 edx, dword ptr [esi + 0x10]
            //   8b4b10               | mov                 ecx, dword ptr [ebx + 0x10]
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   8d0411               | lea                 eax, [ecx + edx]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_1 = { 8b5dd8 ff00 33f6 8b00 0fb608 }
            // n = 5, score = 1900
            //   8b5dd8               | mov                 ebx, dword ptr [ebp - 0x28]
            //   ff00                 | inc                 dword ptr [eax]
            //   33f6                 | xor                 esi, esi
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   0fb608               | movzx               ecx, byte ptr [eax]

        $sequence_2 = { e9???????? c3 8d8d00ffffff e9???????? 8d8d78ffffff }
            // n = 5, score = 1900
            //   e9????????           |                     
            //   c3                   | ret                 
            //   8d8d00ffffff         | lea                 ecx, [ebp - 0x100]
            //   e9????????           |                     
            //   8d8d78ffffff         | lea                 ecx, [ebp - 0x88]

        $sequence_3 = { 8bce ff15???????? 8bcf ffd6 8b8528ffffff }
            // n = 5, score = 1900
            //   8bce                 | mov                 ecx, esi
            //   ff15????????         |                     
            //   8bcf                 | mov                 ecx, edi
            //   ffd6                 | call                esi
            //   8b8528ffffff         | mov                 eax, dword ptr [ebp - 0xd8]

        $sequence_4 = { eb1a 56 53 57 e8???????? 668b4510 }
            // n = 6, score = 1900
            //   eb1a                 | jmp                 0x1c
            //   56                   | push                esi
            //   53                   | push                ebx
            //   57                   | push                edi
            //   e8????????           |                     
            //   668b4510             | mov                 ax, word ptr [ebp + 0x10]

        $sequence_5 = { b8???????? e9???????? 8d8dfcfeffff e9???????? 8d8dfcfeffff e9???????? }
            // n = 6, score = 1900
            //   b8????????           |                     
            //   e9????????           |                     
            //   8d8dfcfeffff         | lea                 ecx, [ebp - 0x104]
            //   e9????????           |                     
            //   8d8dfcfeffff         | lea                 ecx, [ebp - 0x104]
            //   e9????????           |                     

        $sequence_6 = { 3bf7 7cdb 5f 5e 5b }
            // n = 5, score = 1900
            //   3bf7                 | cmp                 esi, edi
            //   7cdb                 | jl                  0xffffffdd
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_7 = { 50 e8???????? 8d4d90 e8???????? e9???????? 8b07 }
            // n = 6, score = 1900
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4d90               | lea                 ecx, [ebp - 0x70]
            //   e8????????           |                     
            //   e9????????           |                     
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_8 = { e9???????? 8b8510ffffff 8b00 8b7018 8d45a8 }
            // n = 5, score = 1900
            //   e9????????           |                     
            //   8b8510ffffff         | mov                 eax, dword ptr [ebp - 0xf0]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b7018               | mov                 esi, dword ptr [eax + 0x18]
            //   8d45a8               | lea                 eax, [ebp - 0x58]

        $sequence_9 = { 85c0 7425 8d3c40 03ff 83ef06 8bd3 }
            // n = 6, score = 1900
            //   85c0                 | test                eax, eax
            //   7425                 | je                  0x27
            //   8d3c40               | lea                 edi, [eax + eax*2]
            //   03ff                 | add                 edi, edi
            //   83ef06               | sub                 edi, 6
            //   8bd3                 | mov                 edx, ebx

    condition:
        7 of them and filesize < 1016832
}