rule win_bs2005_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bs2005."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bs2005"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5f 5e 5b 5d c20400 bf???????? 33db }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   bf????????           |                     
            //   33db                 | xor                 ebx, ebx

        $sequence_1 = { 8b804c000400 50 898748060000 ff15???????? }
            // n = 4, score = 100
            //   8b804c000400         | mov                 eax, dword ptr [eax + 0x4004c]
            //   50                   | push                eax
            //   898748060000         | mov                 dword ptr [edi + 0x648], eax
            //   ff15????????         |                     

        $sequence_2 = { 8d59bf 81e6ff000000 83c8ff 80fb19 7708 0fbec1 }
            // n = 6, score = 100
            //   8d59bf               | lea                 ebx, [ecx - 0x41]
            //   81e6ff000000         | and                 esi, 0xff
            //   83c8ff               | or                  eax, 0xffffffff
            //   80fb19               | cmp                 bl, 0x19
            //   7708                 | ja                  0xa
            //   0fbec1               | movsx               eax, cl

        $sequence_3 = { ff15???????? 85c0 7420 8b8544fbffff 50 ff15???????? 32c0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7420                 | je                  0x22
            //   8b8544fbffff         | mov                 eax, dword ptr [ebp - 0x4bc]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   32c0                 | xor                 al, al

        $sequence_4 = { 55 8bec 803d????????00 53 56 57 747b }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   803d????????00       |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   747b                 | je                  0x7d

        $sequence_5 = { c3 8bff 55 8bec 8b4508 33c9 3b04cda0304100 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   33c9                 | xor                 ecx, ecx
            //   3b04cda0304100       | cmp                 eax, dword ptr [ecx*8 + 0x4130a0]

        $sequence_6 = { 8bf8 57 8d8e1c010c00 51 83c241 }
            // n = 5, score = 100
            //   8bf8                 | mov                 edi, eax
            //   57                   | push                edi
            //   8d8e1c010c00         | lea                 ecx, [esi + 0xc011c]
            //   51                   | push                ecx
            //   83c241               | add                 edx, 0x41

        $sequence_7 = { 81c154010400 8bc1 8d7001 8d4900 }
            // n = 4, score = 100
            //   81c154010400         | add                 ecx, 0x40154
            //   8bc1                 | mov                 eax, ecx
            //   8d7001               | lea                 esi, [eax + 1]
            //   8d4900               | lea                 ecx, [ecx]

        $sequence_8 = { 83c408 85ff 7452 8b7704 85f6 743a 8b06 }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   85ff                 | test                edi, edi
            //   7452                 | je                  0x54
            //   8b7704               | mov                 esi, dword ptr [edi + 4]
            //   85f6                 | test                esi, esi
            //   743a                 | je                  0x3c
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_9 = { ffd3 8b7df0 8b4dfc 83c410 }
            // n = 4, score = 100
            //   ffd3                 | call                ebx
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c410               | add                 esp, 0x10

    condition:
        7 of them and filesize < 212992
}