rule win_btcware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.btcware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.btcware"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 8b857cffffff c7459000000000 c745940f000000 c6458000 }
            // n = 5, score = 100
            //   83c404               | add                 esp, 4
            //   8b857cffffff         | mov                 eax, dword ptr [ebp - 0x84]
            //   c7459000000000       | mov                 dword ptr [ebp - 0x70], 0
            //   c745940f000000       | mov                 dword ptr [ebp - 0x6c], 0xf
            //   c6458000             | mov                 byte ptr [ebp - 0x80], 0

        $sequence_1 = { 6bc930 8b048540d04100 0fb6440828 83e040 5d c3 }
            // n = 6, score = 100
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8b048540d04100       | mov                 eax, dword ptr [eax*4 + 0x41d040]
            //   0fb6440828           | movzx               eax, byte ptr [eax + ecx + 0x28]
            //   83e040               | and                 eax, 0x40
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_2 = { ff75e4 ff15???????? 8d45ec 50 6a01 ff75e4 6810660000 }
            // n = 7, score = 100
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff15????????         |                     
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   6810660000           | push                0x6610

        $sequence_3 = { e8???????? a1???????? 40 3d00100000 722a f6c11f 0f85366fffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   a1????????           |                     
            //   40                   | inc                 eax
            //   3d00100000           | cmp                 eax, 0x1000
            //   722a                 | jb                  0x2c
            //   f6c11f               | test                cl, 0x1f
            //   0f85366fffff         | jne                 0xffff6f3c

        $sequence_4 = { 5d c3 8d44241c c7442414ffffffff 50 8d442424 c744242000800000 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   c7442414ffffffff     | mov                 dword ptr [esp + 0x14], 0xffffffff
            //   50                   | push                eax
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   c744242000800000     | mov                 dword ptr [esp + 0x20], 0x8000

        $sequence_5 = { 8be5 5d c21000 8b8c2494040000 33c0 5f }
            // n = 6, score = 100
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c21000               | ret                 0x10
            //   8b8c2494040000       | mov                 ecx, dword ptr [esp + 0x494]
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi

        $sequence_6 = { 8855ee 0f1f840000000000 8b4610 8b4e14 }
            // n = 4, score = 100
            //   8855ee               | mov                 byte ptr [ebp - 0x12], dl
            //   0f1f840000000000     | nop                 dword ptr [eax + eax]
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]

        $sequence_7 = { ffd3 33d2 33c9 e8???????? 8b35???????? a1???????? }
            // n = 6, score = 100
            //   ffd3                 | call                ebx
            //   33d2                 | xor                 edx, edx
            //   33c9                 | xor                 ecx, ecx
            //   e8????????           |                     
            //   8b35????????         |                     
            //   a1????????           |                     

        $sequence_8 = { c78564ffffff0f000000 c68550ffffff00 83f810 7245 8b8d38ffffff }
            // n = 5, score = 100
            //   c78564ffffff0f000000     | mov    dword ptr [ebp - 0x9c], 0xf
            //   c68550ffffff00       | mov                 byte ptr [ebp - 0xb0], 0
            //   83f810               | cmp                 eax, 0x10
            //   7245                 | jb                  0x47
            //   8b8d38ffffff         | mov                 ecx, dword ptr [ebp - 0xc8]

        $sequence_9 = { 833d????????10 bba0fc8101 a1???????? 0f431d???????? 8a4c3df0 85c0 7416 }
            // n = 7, score = 100
            //   833d????????10       |                     
            //   bba0fc8101           | mov                 ebx, 0x181fca0
            //   a1????????           |                     
            //   0f431d????????       |                     
            //   8a4c3df0             | mov                 cl, byte ptr [ebp + edi - 0x10]
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18

    condition:
        7 of them and filesize < 458752
}