rule win_bughatch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bughatch."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bughatch"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745f800000000 c745fc00000000 6a00 8b4510 50 8d4dfc }
            // n = 6, score = 100
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   6a00                 | push                0
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   50                   | push                eax
            //   8d4dfc               | lea                 ecx, [ebp - 4]

        $sequence_1 = { 6a00 6a12 6a01 e8???????? 83c410 85c0 7528 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6a12                 | push                0x12
            //   6a01                 | push                1
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   7528                 | jne                 0x2a

        $sequence_2 = { 51 6a00 6a01 8b5514 52 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   52                   | push                edx

        $sequence_3 = { 8b4ddc 51 8b5510 52 8b450c 50 e8???????? }
            // n = 7, score = 100
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   51                   | push                ecx
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   52                   | push                edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_4 = { e8???????? 83c408 eb20 8b45f4 50 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   eb20                 | jmp                 0x22
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 8b45fc 8b4df8 3b4818 7365 8b55f8 }
            // n = 5, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   3b4818               | cmp                 ecx, dword ptr [eax + 0x18]
            //   7365                 | jae                 0x67
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_6 = { 50 8d8decfeffff 51 68???????? 8d95e8fdffff 52 ff15???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d8decfeffff         | lea                 ecx, [ebp - 0x114]
            //   51                   | push                ecx
            //   68????????           |                     
            //   8d95e8fdffff         | lea                 edx, [ebp - 0x218]
            //   52                   | push                edx
            //   ff15????????         |                     

        $sequence_7 = { 894a04 eb09 c745f400000000 eb02 eba0 }
            // n = 5, score = 100
            //   894a04               | mov                 dword ptr [edx + 4], ecx
            //   eb09                 | jmp                 0xb
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   eb02                 | jmp                 4
            //   eba0                 | jmp                 0xffffffa2

        $sequence_8 = { 8bec 83ec18 c745fc00000000 c745f800000000 8d45fc 50 6a28 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec18               | sub                 esp, 0x18
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6a28                 | push                0x28

        $sequence_9 = { ff15???????? 8b55f8 0355f4 8955f8 b801000000 6bc800 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   0355f4               | add                 edx, dword ptr [ebp - 0xc]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   b801000000           | mov                 eax, 1
            //   6bc800               | imul                ecx, eax, 0

    condition:
        7 of them and filesize < 75776
}