rule win_c0d0so0_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.c0d0so0."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.c0d0so0"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 0f84c3000000 03c3 50 }
            // n = 4, score = 600
            //   85c0                 | test                eax, eax
            //   0f84c3000000         | je                  0xc9
            //   03c3                 | add                 eax, ebx
            //   50                   | push                eax

        $sequence_1 = { ff15???????? f6450820 0f8520010000 395d08 0f8417010000 }
            // n = 5, score = 600
            //   ff15????????         |                     
            //   f6450820             | test                byte ptr [ebp + 8], 0x20
            //   0f8520010000         | jne                 0x126
            //   395d08               | cmp                 dword ptr [ebp + 8], ebx
            //   0f8417010000         | je                  0x11d

        $sequence_2 = { 8b0e 33c0 83e912 57 7411 8a4e04 }
            // n = 6, score = 600
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   33c0                 | xor                 eax, eax
            //   83e912               | sub                 ecx, 0x12
            //   57                   | push                edi
            //   7411                 | je                  0x13
            //   8a4e04               | mov                 cl, byte ptr [esi + 4]

        $sequence_3 = { 4a 7417 4a 740f 4a }
            // n = 5, score = 600
            //   4a                   | dec                 edx
            //   7417                 | je                  0x19
            //   4a                   | dec                 edx
            //   740f                 | je                  0x11
            //   4a                   | dec                 edx

        $sequence_4 = { eb62 8d45f4 50 57 8d45fc }
            // n = 5, score = 600
            //   eb62                 | jmp                 0x64
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   57                   | push                edi
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_5 = { 0b4f04 7506 8b00 85c0 75e2 53 }
            // n = 6, score = 600
            //   0b4f04               | or                  ecx, dword ptr [edi + 4]
            //   7506                 | jne                 8
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   85c0                 | test                eax, eax
            //   75e2                 | jne                 0xffffffe4
            //   53                   | push                ebx

        $sequence_6 = { 83c40c 6a64 8d4598 50 33ff }
            // n = 5, score = 600
            //   83c40c               | add                 esp, 0xc
            //   6a64                 | push                0x64
            //   8d4598               | lea                 eax, [ebp - 0x68]
            //   50                   | push                eax
            //   33ff                 | xor                 edi, edi

        $sequence_7 = { 6a00 ffd6 50 ff15???????? 8bd8 85db 7503 }
            // n = 7, score = 600
            //   6a00                 | push                0
            //   ffd6                 | call                esi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   7503                 | jne                 5

        $sequence_8 = { 83e20f 4a 742f 4a 7427 4a 741f }
            // n = 7, score = 600
            //   83e20f               | and                 edx, 0xf
            //   4a                   | dec                 edx
            //   742f                 | je                  0x31
            //   4a                   | dec                 edx
            //   7427                 | je                  0x29
            //   4a                   | dec                 edx
            //   741f                 | je                  0x21

        $sequence_9 = { eb07 8a4901 eb02 8a09 57 }
            // n = 5, score = 600
            //   eb07                 | jmp                 9
            //   8a4901               | mov                 cl, byte ptr [ecx + 1]
            //   eb02                 | jmp                 4
            //   8a09                 | mov                 cl, byte ptr [ecx]
            //   57                   | push                edi

    condition:
        7 of them and filesize < 450560
}