rule win_ceeloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ceeloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ceeloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c8ff f00fc101 83f801 751c 488b45e8 488b8888000000 488d05f5cf0800 }
            // n = 7, score = 100
            //   83c8ff               | mov                 dword ptr [esp + 0xc70], 0x3aba
            //   f00fc101             | mov                 dword ptr [esp + 0xc6c], 0x2122
            //   83f801               | mov                 dword ptr [esp + 0xc68], 0x52f7
            //   751c                 | mov                 dword ptr [esp + 0xc64], 0x4b7d
            //   488b45e8             | mov                 dword ptr [esp + 0x180], 0
            //   488b8888000000       | mov                 dword ptr [esp + 0x44], eax
            //   488d05f5cf0800       | mov                 eax, dword ptr [esp + 0x180]

        $sequence_1 = { 89842488040000 8b84245c0c0000 0b8424600c0000 8984245c0c0000 8b8424600c0000 0b8424600c0000 898424600c0000 }
            // n = 7, score = 100
            //   89842488040000       | cmp                 ecx, esi
            //   8b84245c0c0000       | or                  eax, ebx
            //   0b8424600c0000       | jp                  0x2fc
            //   8984245c0c0000       | or                  ebx, edx
            //   8b8424600c0000       | or                  ebx, edx
            //   0b8424600c0000       | mov                 ebx, esi
            //   898424600c0000       | or                  edx, ebx

        $sequence_2 = { 448b942444020000 4531d0 c78424b40d000000000000 488b9424d8070000 48898c2438020000 4889d1 488d1521160b00 }
            // n = 7, score = 100
            //   448b942444020000     | mov                 dword ptr [esp + 0xa8], eax
            //   4531d0               | mov                 byte ptr [esp + 0xb6], cl
            //   c78424b40d000000000000     | xor    eax, 0x6e
            //   488b9424d8070000     | mov                 cl, al
            //   48898c2438020000     | mov                 byte ptr [esp + 0xb7], cl
            //   4889d1               | mov                 byte ptr [esp + 0x3b6], cl
            //   488d1521160b00       | xor                 eax, 0x69

        $sequence_3 = { 44899c2454040000 448b9c2454040000 89c6 81e6b1524402 89b42450040000 8bb42450040000 c1e604 }
            // n = 7, score = 100
            //   44899c2454040000     | mov                 si, word ptr [esp + 0x1242]
            //   448b9c2454040000     | mov                 word ptr [esp + 0x1240], 0
            //   89c6                 | mov                 di, word ptr [esp + 0x1240]
            //   81e6b1524402         | xor                 di, 0xffff
            //   89b42450040000       | mov                 word ptr [esp + 0x123e], di
            //   8bb42450040000       | mov                 word ptr [esp + 0xd50], si
            //   c1e604               | add                 dx, word ptr [esp + 0xd50]

        $sequence_4 = { 4181e100ffffff 44898c24fc000000 448b8c24fc000000 448b15???????? 4501c8 4539d0 48898424b0000000 }
            // n = 7, score = 100
            //   4181e100ffffff       | dec                 eax
            //   44898c24fc000000     | mov                 dword ptr [esp + 0x118], 0
            //   448b8c24fc000000     | dec                 eax
            //   448b15????????       |                     
            //   4501c8               | mov                 ecx, eax
            //   4539d0               | dec                 eax
            //   48898424b0000000     | mov                 eax, dword ptr [esp + 0xf0]

        $sequence_5 = { 0f8433000000 8b842418010000 898424d0000000 e8???????? 8b8c2414010000 2b8c2418010000 99 }
            // n = 7, score = 100
            //   0f8433000000         | inc                 ecx
            //   8b842418010000       | mov                 ebx, eax
            //   898424d0000000       | inc                 ecx
            //   e8????????           |                     
            //   8b8c2414010000       | xor                 ebx, 0xffffffff
            //   2b8c2418010000       | inc                 esp
            //   99                   | mov                 dword ptr [esp + 0xde8], ebx

        $sequence_6 = { 4c8d0d7d050e00 488b8c2410010000 4889942400010000 4c89ca 4c8b8c2400010000 898424fc000000 ff15???????? }
            // n = 7, score = 100
            //   4c8d0d7d050e00       | mov                 edx, dword ptr [esp + 0x6c]
            //   488b8c2410010000     | dec                 esp
            //   4889942400010000     | mov                 ecx, dword ptr [esp + 0x60]
            //   4c89ca               | mov                 dword ptr [esp + 0x200], 0
            //   4c8b8c2400010000     | mov                 ecx, dword ptr [esp + 0x200]
            //   898424fc000000       | mov                 dword ptr [esp + 0x1fc], eax
            //   ff15????????         |                     

        $sequence_7 = { 6689d3 66239c2476110000 66899c2474110000 6689d3 66239c2474110000 66899c2472110000 6689d3 }
            // n = 7, score = 100
            //   6689d3               | mov                 dword ptr [esp + 0xb64], 0x37b
            //   66239c2476110000     | mov                 dword ptr [esp + 0xd78], 0x18
            //   66899c2474110000     | mov                 byte ptr [esp + 0xd77], 0
            //   6689d3               | dec                 eax
            //   66239c2474110000     | mov                 dword ptr [esp + 0xd68], eax
            //   66899c2472110000     | mov                 dword ptr [esp + 0xd64], 0
            //   6689d3               | mov                 eax, dword ptr [esp + 0xd64]

        $sequence_8 = { 4181e1f5274b02 44898c24d0050000 448b8c24d0050000 4189c2 4181e2f5274b02 44899424cc050000 448b9424cc050000 }
            // n = 7, score = 100
            //   4181e1f5274b02       | dec                 esp
            //   44898c24d0050000     | lea                 ecx, [esp + 0xdbc]
            //   448b8c24d0050000     | dec                 eax
            //   4189c2               | mov                 dword ptr [esp + 0x20], 0
            //   4181e2f5274b02       | inc                 esp
            //   44899424cc050000     | mov                 dword ptr [esp + 0x258], edx
            //   448b9424cc050000     | dec                 eax

        $sequence_9 = { 0315???????? 8915???????? 8b15???????? 448b05???????? 4189d2 4531c2 4431d2 }
            // n = 7, score = 100
            //   0315????????         |                     
            //   8915????????         |                     
            //   8b15????????         |                     
            //   448b05????????       |                     
            //   4189d2               | mov                 ecx, eax
            //   4531c2               | inc                 esp
            //   4431d2               | mov                 eax, dword ptr [esp + 0x5c]

    condition:
        7 of them and filesize < 2321408
}