rule win_chainshot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.chainshot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chainshot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d5e30 8bcb e8???????? }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8d5e30               | pop                 edi
            //   8bcb                 | mov                 esi, 0x80000016
            //   e8????????           |                     

        $sequence_1 = { 7408 ffd0 8905???????? b90c000080 894c2420 }
            // n = 5, score = 300
            //   7408                 | inc                 ecx
            //   ffd0                 | push                esi
            //   8905????????         |                     
            //   b90c000080           | dec                 eax
            //   894c2420             | mov                 ebp, esp

        $sequence_2 = { 33d2 85c0 750a b901090080 e9???????? }
            // n = 5, score = 300
            //   33d2                 | movzx               eax, byte ptr [edi + 0x292a]
            //   85c0                 | or                  ecx, eax
            //   750a                 | xor                 ecx, 0xffff
            //   b901090080           | inc                 esp
            //   e9????????           |                     

        $sequence_3 = { 894718 0f84740b0000 83f803 0f84bb0e0000 83f801 }
            // n = 5, score = 300
            //   894718               | and                 dword ptr [edi], 0
            //   0f84740b0000         | mov                 eax, ebx
            //   83f803               | dec                 eax
            //   0f84bb0e0000         | mov                 ebx, dword ptr [esp + 0x38]
            //   83f801               | test                eax, eax

        $sequence_4 = { 750c 807b0208 7506 807b030d 7449 }
            // n = 5, score = 300
            //   750c                 | mov                 dword ptr [esp + 0x14], 0x3fab0000
            //   807b0208             | lea                 ecx, [esp + 0x27]
            //   7506                 | mov                 dword ptr [esp + 0x18], 0xa0000
            //   807b030d             | mov                 word ptr [esp + 0x734], dx
            //   7449                 | movdqu              xmmword ptr [esp + 0x82c], xmm0

        $sequence_5 = { b9020e0080 e8???????? b916000000 e8???????? }
            // n = 4, score = 300
            //   b9020e0080           | lea                 ecx, [eax + eax*4]
            //   e8????????           |                     
            //   b916000000           | dec                 ecx
            //   e8????????           |                     

        $sequence_6 = { ffd0 8905???????? bb52000080 eb03 }
            // n = 4, score = 300
            //   ffd0                 | dec                 ebp
            //   8905????????         |                     
            //   bb52000080           | mov                 eax, edi
            //   eb03                 | mov                 ecx, 0x206

        $sequence_7 = { 33d2 b907080080 e8???????? 32db eb24 33d2 }
            // n = 6, score = 300
            //   33d2                 | dec                 eax
            //   b907080080           | mov                 ecx, ebx
            //   e8????????           |                     
            //   32db                 | dec                 esp
            //   eb24                 | mov                 eax, ebx
            //   33d2                 | mov                 ebx, 4

        $sequence_8 = { 8b4d50 85c9 7507 b9070e0080 eb17 }
            // n = 5, score = 300
            //   8b4d50               | jne                 0xefe
            //   85c9                 | mov                 dword ptr [ebp - 0x1c], eax
            //   7507                 | mov                 dword ptr [ebp - 4], eax
            //   b9070e0080           | cmp                 dword ptr [eax], edi
            //   eb17                 | je                  0xf03

        $sequence_9 = { 75d0 85ff 745d 83ff04 }
            // n = 4, score = 300
            //   75d0                 | dec                 eax
            //   85ff                 | lea                 ecx, [0x164a5]
            //   745d                 | test                eax, eax
            //   83ff04               | je                  0x145

    condition:
        7 of them and filesize < 802816
}