rule win_chewbacca_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.chewbacca."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chewbacca"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c744240cf2020000 89442408 c7442404???????? a1???????? 83c040 890424 e8???????? }
            // n = 7, score = 100
            //   c744240cf2020000     | mov                 dword ptr [esp + 0xc], 0x2f2
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   c7442404????????     |                     
            //   a1????????           |                     
            //   83c040               | add                 eax, 0x40
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_1 = { e8???????? e8???????? 83b83003000000 7505 bb???????? 89d8 83c428 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e8????????           |                     
            //   83b83003000000       | cmp                 dword ptr [eax + 0x330], 0
            //   7505                 | jne                 7
            //   bb????????           |                     
            //   89d8                 | mov                 eax, ebx
            //   83c428               | add                 esp, 0x28

        $sequence_2 = { c7442408???????? c744240400080000 c7042406000000 e8???????? 8b442454 890424 e8???????? }
            // n = 7, score = 100
            //   c7442408????????     |                     
            //   c744240400080000     | mov                 dword ptr [esp + 4], 0x800
            //   c7042406000000       | mov                 dword ptr [esp], 6
            //   e8????????           |                     
            //   8b442454             | mov                 eax, dword ptr [esp + 0x54]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_3 = { c744240400100000 c7042403000000 e8???????? c70424???????? e8???????? c7442414003b6800 c7442410ee3d6800 }
            // n = 7, score = 100
            //   c744240400100000     | mov                 dword ptr [esp + 4], 0x1000
            //   c7042403000000       | mov                 dword ptr [esp], 3
            //   e8????????           |                     
            //   c70424????????       |                     
            //   e8????????           |                     
            //   c7442414003b6800     | mov                 dword ptr [esp + 0x14], 0x683b00
            //   c7442410ee3d6800     | mov                 dword ptr [esp + 0x10], 0x683dee

        $sequence_4 = { c7442408???????? c744240400100000 c7042403000000 e8???????? c70424???????? e8???????? c74424140c136800 }
            // n = 7, score = 100
            //   c7442408????????     |                     
            //   c744240400100000     | mov                 dword ptr [esp + 4], 0x1000
            //   c7042403000000       | mov                 dword ptr [esp], 3
            //   e8????????           |                     
            //   c70424????????       |                     
            //   e8????????           |                     
            //   c74424140c136800     | mov                 dword ptr [esp + 0x14], 0x68130c

        $sequence_5 = { ff8bc0000000 837c243800 7410 39f3 740c 895c2404 892c24 }
            // n = 7, score = 100
            //   ff8bc0000000         | dec                 dword ptr [ebx + 0xc0]
            //   837c243800           | cmp                 dword ptr [esp + 0x38], 0
            //   7410                 | je                  0x12
            //   39f3                 | cmp                 ebx, esi
            //   740c                 | je                  0xe
            //   895c2404             | mov                 dword ptr [esp + 4], ebx
            //   892c24               | mov                 dword ptr [esp], ebp

        $sequence_6 = { a1???????? ffd2 eb05 b8???????? 8918 e8???????? 5b }
            // n = 7, score = 100
            //   a1????????           |                     
            //   ffd2                 | call                edx
            //   eb05                 | jmp                 7
            //   b8????????           |                     
            //   8918                 | mov                 dword ptr [eax], ebx
            //   e8????????           |                     
            //   5b                   | pop                 ebx

        $sequence_7 = { ff5270 85d2 7f0d 0f8c7b000000 3d00000100 7274 8d954cffffff }
            // n = 7, score = 100
            //   ff5270               | call                dword ptr [edx + 0x70]
            //   85d2                 | test                edx, edx
            //   7f0d                 | jg                  0xf
            //   0f8c7b000000         | jl                  0x81
            //   3d00000100           | cmp                 eax, 0x10000
            //   7274                 | jb                  0x76
            //   8d954cffffff         | lea                 edx, [ebp - 0xb4]

        $sequence_8 = { e8???????? b801000000 8d5598 8d4db4 e8???????? e8???????? 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b801000000           | mov                 eax, 1
            //   8d5598               | lea                 edx, [ebp - 0x68]
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]
            //   e8????????           |                     
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_9 = { e8???????? 8b4308 8b10 8b4004 f7d0 f7da 83d8ff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   f7d0                 | not                 eax
            //   f7da                 | neg                 edx
            //   83d8ff               | sbb                 eax, -1

    condition:
        7 of them and filesize < 9764864
}