rule win_chinad_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.chinad."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chinad"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8528e5ffff 0f94c1 898d3ce5ffff 8b8d24e5ffff 8b048588ec4300 ff3401 ff15???????? }
            // n = 7, score = 200
            //   8b8528e5ffff         | mov                 eax, dword ptr [ebp - 0x1ad8]
            //   0f94c1               | sete                cl
            //   898d3ce5ffff         | mov                 dword ptr [ebp - 0x1ac4], ecx
            //   8b8d24e5ffff         | mov                 ecx, dword ptr [ebp - 0x1adc]
            //   8b048588ec4300       | mov                 eax, dword ptr [eax*4 + 0x43ec88]
            //   ff3401               | push                dword ptr [ecx + eax]
            //   ff15????????         |                     

        $sequence_1 = { 8b9dd0feffff 8b8dc0feffff c1c007 33cb 33d0 23ce }
            // n = 6, score = 200
            //   8b9dd0feffff         | mov                 ebx, dword ptr [ebp - 0x130]
            //   8b8dc0feffff         | mov                 ecx, dword ptr [ebp - 0x140]
            //   c1c007               | rol                 eax, 7
            //   33cb                 | xor                 ecx, ebx
            //   33d0                 | xor                 edx, eax
            //   23ce                 | and                 ecx, esi

        $sequence_2 = { 8b5584 899554ffffff 83bd54ffffff00 750a e8???????? e9???????? c745c4ec284300 }
            // n = 7, score = 200
            //   8b5584               | mov                 edx, dword ptr [ebp - 0x7c]
            //   899554ffffff         | mov                 dword ptr [ebp - 0xac], edx
            //   83bd54ffffff00       | cmp                 dword ptr [ebp - 0xac], 0
            //   750a                 | jne                 0xc
            //   e8????????           |                     
            //   e9????????           |                     
            //   c745c4ec284300       | mov                 dword ptr [ebp - 0x3c], 0x4328ec

        $sequence_3 = { 8b45e0 0facf010 c1e105 0ac8 c1fe10 8b7508 8bc2 }
            // n = 7, score = 200
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   0facf010             | shrd                eax, esi, 0x10
            //   c1e105               | shl                 ecx, 5
            //   0ac8                 | or                  cl, al
            //   c1fe10               | sar                 esi, 0x10
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8bc2                 | mov                 eax, edx

        $sequence_4 = { 0b9528fdffff 23b50cfdffff 2395fcfcffff 238d04fdffff 0bf1 8b8534fdffff 238528fdffff }
            // n = 7, score = 200
            //   0b9528fdffff         | or                  edx, dword ptr [ebp - 0x2d8]
            //   23b50cfdffff         | and                 esi, dword ptr [ebp - 0x2f4]
            //   2395fcfcffff         | and                 edx, dword ptr [ebp - 0x304]
            //   238d04fdffff         | and                 ecx, dword ptr [ebp - 0x2fc]
            //   0bf1                 | or                  esi, ecx
            //   8b8534fdffff         | mov                 eax, dword ptr [ebp - 0x2cc]
            //   238528fdffff         | and                 eax, dword ptr [ebp - 0x2d8]

        $sequence_5 = { 6a04 8d8df0efffff 51 6a06 8b95f8efffff 52 ff15???????? }
            // n = 7, score = 200
            //   6a04                 | push                4
            //   8d8df0efffff         | lea                 ecx, [ebp - 0x1010]
            //   51                   | push                ecx
            //   6a06                 | push                6
            //   8b95f8efffff         | mov                 edx, dword ptr [ebp - 0x1008]
            //   52                   | push                edx
            //   ff15????????         |                     

        $sequence_6 = { 0fa4c117 c1eb09 c1e017 0bf9 8b8d34fdffff 0bd8 }
            // n = 6, score = 200
            //   0fa4c117             | shld                ecx, eax, 0x17
            //   c1eb09               | shr                 ebx, 9
            //   c1e017               | shl                 eax, 0x17
            //   0bf9                 | or                  edi, ecx
            //   8b8d34fdffff         | mov                 ecx, dword ptr [ebp - 0x2cc]
            //   0bd8                 | or                  ebx, eax

        $sequence_7 = { 894de4 6a09 50 e8???????? 8b4ddc 33c8 }
            // n = 6, score = 200
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   6a09                 | push                9
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   33c8                 | xor                 ecx, eax

        $sequence_8 = { 83c108 894d90 8b55ac 8955ec 8b4590 8b4804 }
            // n = 6, score = 200
            //   83c108               | add                 ecx, 8
            //   894d90               | mov                 dword ptr [ebp - 0x70], ecx
            //   8b55ac               | mov                 edx, dword ptr [ebp - 0x54]
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   8b4590               | mov                 eax, dword ptr [ebp - 0x70]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]

        $sequence_9 = { 8b95d8feffff 23fe 0bf8 8bc3 c1c007 89bdd0feffff 018dd0feffff }
            // n = 7, score = 200
            //   8b95d8feffff         | mov                 edx, dword ptr [ebp - 0x128]
            //   23fe                 | and                 edi, esi
            //   0bf8                 | or                  edi, eax
            //   8bc3                 | mov                 eax, ebx
            //   c1c007               | rol                 eax, 7
            //   89bdd0feffff         | mov                 dword ptr [ebp - 0x130], edi
            //   018dd0feffff         | add                 dword ptr [ebp - 0x130], ecx

    condition:
        7 of them and filesize < 598016
}