rule win_chir_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.chir."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chir"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45f4 50 c745f421352432 c745f851173300 e8???????? }
            // n = 5, score = 300
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   c745f421352432       | mov                 dword ptr [ebp - 0xc], 0x32243521
            //   c745f851173300       | mov                 dword ptr [ebp - 8], 0x331751
            //   e8????????           |                     

        $sequence_1 = { 48 59 6a00 5e 7419 8d4c35f8 8a11 }
            // n = 7, score = 300
            //   48                   | dec                 eax
            //   59                   | pop                 ecx
            //   6a00                 | push                0
            //   5e                   | pop                 esi
            //   7419                 | je                  0x1b
            //   8d4c35f8             | lea                 ecx, [ebp + esi - 8]
            //   8a11                 | mov                 dl, byte ptr [ecx]

        $sequence_2 = { c745fc51173300 e8???????? 83c410 48 }
            // n = 4, score = 300
            //   c745fc51173300       | mov                 dword ptr [ebp - 4], 0x331751
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   48                   | dec                 eax

        $sequence_3 = { 33c9 807df905 0f94c1 33d2 48 8d4c0901 }
            // n = 6, score = 300
            //   33c9                 | xor                 ecx, ecx
            //   807df905             | cmp                 byte ptr [ebp - 7], 5
            //   0f94c1               | sete                cl
            //   33d2                 | xor                 edx, edx
            //   48                   | dec                 eax
            //   8d4c0901             | lea                 ecx, [ecx + ecx + 1]

        $sequence_4 = { 59 8bfb 7419 8d4c3df0 8a11 }
            // n = 5, score = 300
            //   59                   | pop                 ecx
            //   8bfb                 | mov                 edi, ebx
            //   7419                 | je                  0x1b
            //   8d4c3df0             | lea                 ecx, [ebp + edi - 0x10]
            //   8a11                 | mov                 dl, byte ptr [ecx]

        $sequence_5 = { e8???????? 59 33c9 48 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   33c9                 | xor                 ecx, ecx
            //   48                   | dec                 eax

        $sequence_6 = { 8811 3bf0 72e7 57 }
            // n = 4, score = 300
            //   8811                 | mov                 byte ptr [ecx], dl
            //   3bf0                 | cmp                 esi, eax
            //   72e7                 | jb                  0xffffffe9
            //   57                   | push                edi

        $sequence_7 = { 8bc4 fc 56 57 }
            // n = 4, score = 300
            //   8bc4                 | mov                 eax, esp
            //   fc                   | cld                 
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_8 = { 8bfb 7419 8d4c3df0 8a11 80f2fc 80c202 }
            // n = 6, score = 300
            //   8bfb                 | mov                 edi, ebx
            //   7419                 | je                  0x1b
            //   8d4c3df0             | lea                 ecx, [ebp + edi - 0x10]
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   80f2fc               | xor                 dl, 0xfc
            //   80c202               | add                 dl, 2

        $sequence_9 = { 8d45f8 50 c745f840214125 c745fc32212400 }
            // n = 4, score = 300
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   c745f840214125       | mov                 dword ptr [ebp - 8], 0x25412140
            //   c745fc32212400       | mov                 dword ptr [ebp - 4], 0x242132

    condition:
        7 of them and filesize < 286720
}