rule win_clambling_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.clambling."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.clambling"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b910000000 ff15???????? 66448bd8 41c1eb0b 4180e310 4180cb2f e9???????? }
            // n = 7, score = 300
            //   b910000000           | mov                 byte ptr [esp + 0x78], 0x71
            //   ff15????????         |                     
            //   66448bd8             | mov                 byte ptr [esp + 0x79], 0x77
            //   41c1eb0b             | mov                 byte ptr [esp + 0x74], 0x72
            //   4180e310             | mov                 byte ptr [esp + 0x75], 0x66
            //   4180cb2f             | mov                 byte ptr [esp + 0x76], 0x33
            //   e9????????           |                     

        $sequence_1 = { ba04010000 ff15???????? 83f8ff 7508 ff15???????? }
            // n = 5, score = 300
            //   ba04010000           | lea                 ecx, [esi + esi*2]
            //   ff15????????         |                     
            //   83f8ff               | dec                 eax
            //   7508                 | cmp                 dword ptr [eax + ecx*8 + 8], 0
            //   ff15????????         |                     

        $sequence_2 = { b940000000 ff15???????? 448b8c24a0000000 488b8c24b0000000 }
            // n = 4, score = 300
            //   b940000000           | je                  0x1806
            //   ff15????????         |                     
            //   448b8c24a0000000     | dec                 ecx
            //   488b8c24b0000000     | mov                 esi, eax

        $sequence_3 = { 56 57 4154 4155 4883ec68 4533ed }
            // n = 6, score = 300
            //   56                   | mov                 cl, byte ptr [ebx + 6]
            //   57                   | inc                 ebp
            //   4154                 | xor                 ecx, ecx
            //   4155                 | jmp                 0x1ae9
            //   4883ec68             | dec                 eax
            //   4533ed               | mov                 eax, dword ptr [ebx]

        $sequence_4 = { 8bd8 488b8c24a8010000 ff15???????? eb08 ff15???????? }
            // n = 5, score = 300
            //   8bd8                 | dec                 eax
            //   488b8c24a8010000     | lea                 ebx, [0x6193]
            //   ff15????????         |                     
            //   eb08                 | dec                 eax
            //   ff15????????         |                     

        $sequence_5 = { 7448 4c8d442434 488bd7 33c9 ff15???????? }
            // n = 5, score = 300
            //   7448                 | sub                 esp, 0x230
            //   4c8d442434           | dec                 ecx
            //   488bd7               | mov                 ebp, eax
            //   33c9                 | dec                 esp
            //   ff15????????         |                     

        $sequence_6 = { 750b ff15???????? e9???????? 0fbfeb }
            // n = 4, score = 300
            //   750b                 | test                eax, eax
            //   ff15????????         |                     
            //   e9????????           |                     
            //   0fbfeb               | dec                 eax

        $sequence_7 = { ffc7 4503e7 3bfd 7ce0 668b5c2430 }
            // n = 5, score = 300
            //   ffc7                 | dec                 eax
            //   4503e7               | mov                 edi, eax
            //   3bfd                 | dec                 ecx
            //   7ce0                 | cmp                 eax, esp
            //   668b5c2430           | je                  0x10cd

        $sequence_8 = { 488b8c24a8010000 ff15???????? 8907 eb08 ff15???????? 8bd8 488b8c24a8010000 }
            // n = 7, score = 300
            //   488b8c24a8010000     | mov                 dword ptr [esp + 0x38], eax
            //   ff15????????         |                     
            //   8907                 | dec                 eax
            //   eb08                 | lea                 eax, [esp + 0x60]
            //   ff15????????         |                     
            //   8bd8                 | dec                 eax
            //   488b8c24a8010000     | mov                 dword ptr [esp + 0x30], eax

        $sequence_9 = { 8bf1 894c2438 6683c303 6681e3fcff }
            // n = 4, score = 300
            //   8bf1                 | jne                 0x221
            //   894c2438             | dec                 eax
            //   6683c303             | inc                 edi
            //   6681e3fcff           | dec                 ecx

    condition:
        7 of them and filesize < 412672
}