rule win_client_maximus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.client_maximus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.client_maximus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c601 39730c 7fe1 891424 e8???????? }
            // n = 5, score = 300
            //   83c601               | add                 esi, 1
            //   39730c               | cmp                 dword ptr [ebx + 0xc], esi
            //   7fe1                 | jg                  0xffffffe3
            //   891424               | mov                 dword ptr [esp], edx
            //   e8????????           |                     

        $sequence_1 = { 83c601 39730c 7fe1 891424 e8???????? 8b4304 }
            // n = 6, score = 300
            //   83c601               | add                 esi, 1
            //   39730c               | cmp                 dword ptr [ebx + 0xc], esi
            //   7fe1                 | jg                  0xffffffe3
            //   891424               | mov                 dword ptr [esp], edx
            //   e8????????           |                     
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]

        $sequence_2 = { 8b5330 c744240800800000 c744240400000000 890424 8954240c ff5320 ff15???????? }
            // n = 7, score = 300
            //   8b5330               | mov                 edx, dword ptr [ebx + 0x30]
            //   c744240800800000     | mov                 dword ptr [esp + 8], 0x8000
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   890424               | mov                 dword ptr [esp], eax
            //   8954240c             | mov                 dword ptr [esp + 0xc], edx
            //   ff5320               | call                dword ptr [ebx + 0x20]
            //   ff15????????         |                     

        $sequence_3 = { 89f8 02441500 01c6 89f0 0fb6c0 }
            // n = 5, score = 300
            //   89f8                 | mov                 eax, edi
            //   02441500             | add                 al, byte ptr [ebp + edx]
            //   01c6                 | add                 esi, eax
            //   89f0                 | mov                 eax, esi
            //   0fb6c0               | movzx               eax, al

        $sequence_4 = { 81f900010000 881403 75d1 5b 5e }
            // n = 5, score = 300
            //   81f900010000         | cmp                 ecx, 0x100
            //   881403               | mov                 byte ptr [ebx + eax], dl
            //   75d1                 | jne                 0xffffffd3
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

        $sequence_5 = { 8b442420 c70424???????? a3???????? e8???????? b801000000 }
            // n = 5, score = 300
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   c70424????????       |                     
            //   a3????????           |                     
            //   e8????????           |                     
            //   b801000000           | mov                 eax, 1

        $sequence_6 = { 56 53 8b5c2414 8b6c2418 6690 880403 83c001 }
            // n = 7, score = 300
            //   56                   | push                esi
            //   53                   | push                ebx
            //   8b5c2414             | mov                 ebx, dword ptr [esp + 0x14]
            //   8b6c2418             | mov                 ebp, dword ptr [esp + 0x18]
            //   6690                 | nop                 
            //   880403               | mov                 byte ptr [ebx + eax], al
            //   83c001               | add                 eax, 1

        $sequence_7 = { 85c0 7438 c70424???????? ffd3 }
            // n = 4, score = 300
            //   85c0                 | test                eax, eax
            //   7438                 | je                  0x3a
            //   c70424????????       |                     
            //   ffd3                 | call                ebx

        $sequence_8 = { 89f0 0fb6c0 0fb61403 88140b }
            // n = 4, score = 300
            //   89f0                 | mov                 eax, esi
            //   0fb6c0               | movzx               eax, al
            //   0fb61403             | movzx               edx, byte ptr [ebx + eax]
            //   88140b               | mov                 byte ptr [ebx + ecx], dl

        $sequence_9 = { 85d2 7511 8b5034 85d2 740a 8b4018 85c0 }
            // n = 7, score = 300
            //   85d2                 | test                edx, edx
            //   7511                 | jne                 0x13
            //   8b5034               | mov                 edx, dword ptr [eax + 0x34]
            //   85d2                 | test                edx, edx
            //   740a                 | je                  0xc
            //   8b4018               | mov                 eax, dword ptr [eax + 0x18]
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 106496
}