rule win_cloud_duke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cloud_duke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cloud_duke"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8844241b e9???????? 8bce b8???????? }
            // n = 4, score = 800
            //   8844241b             | mov                 byte ptr [esp + 0x1b], al
            //   e9????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   b8????????           |                     

        $sequence_1 = { 8d8c241c030000 8d5102 8d642400 668b01 83c102 6685c0 75f5 }
            // n = 7, score = 800
            //   8d8c241c030000       | lea                 ecx, [esp + 0x31c]
            //   8d5102               | lea                 edx, [ecx + 2]
            //   8d642400             | lea                 esp, [esp]
            //   668b01               | mov                 ax, word ptr [ecx]
            //   83c102               | add                 ecx, 2
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7

        $sequence_2 = { 2bca 8b95dcfbffff d1f9 8d4202 8985e0fbffff 8bff 668b02 }
            // n = 7, score = 800
            //   2bca                 | sub                 ecx, edx
            //   8b95dcfbffff         | mov                 edx, dword ptr [ebp - 0x424]
            //   d1f9                 | sar                 ecx, 1
            //   8d4202               | lea                 eax, [edx + 2]
            //   8985e0fbffff         | mov                 dword ptr [ebp - 0x420], eax
            //   8bff                 | mov                 edi, edi
            //   668b02               | mov                 ax, word ptr [edx]

        $sequence_3 = { 83c404 ff742424 e8???????? 8b44246c }
            // n = 4, score = 800
            //   83c404               | add                 esp, 4
            //   ff742424             | push                dword ptr [esp + 0x24]
            //   e8????????           |                     
            //   8b44246c             | mov                 eax, dword ptr [esp + 0x6c]

        $sequence_4 = { 81e1ff000080 7908 49 81c900ffffff 41 880c3e 46 }
            // n = 7, score = 800
            //   81e1ff000080         | and                 ecx, 0x800000ff
            //   7908                 | jns                 0xa
            //   49                   | dec                 ecx
            //   81c900ffffff         | or                  ecx, 0xffffff00
            //   41                   | inc                 ecx
            //   880c3e               | mov                 byte ptr [esi + edi], cl
            //   46                   | inc                 esi

        $sequence_5 = { 57 51 8d8c24e4000000 e8???????? 83c410 84c0 7437 }
            // n = 7, score = 800
            //   57                   | push                edi
            //   51                   | push                ecx
            //   8d8c24e4000000       | lea                 ecx, [esp + 0xe4]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   84c0                 | test                al, al
            //   7437                 | je                  0x39

        $sequence_6 = { 42 8954242c 3b94243c010000 0f8cc7f4ffff 8b742424 e9???????? }
            // n = 6, score = 800
            //   42                   | inc                 edx
            //   8954242c             | mov                 dword ptr [esp + 0x2c], edx
            //   3b94243c010000       | cmp                 edx, dword ptr [esp + 0x13c]
            //   0f8cc7f4ffff         | jl                  0xfffff4cd
            //   8b742424             | mov                 esi, dword ptr [esp + 0x24]
            //   e9????????           |                     

        $sequence_7 = { 8b4e10 2bc1 83f801 0f868c000000 8d7901 }
            // n = 5, score = 800
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   2bc1                 | sub                 eax, ecx
            //   83f801               | cmp                 eax, 1
            //   0f868c000000         | jbe                 0x92
            //   8d7901               | lea                 edi, [ecx + 1]

        $sequence_8 = { 6a3c 6a00 50 e8???????? 8d842428030000 }
            // n = 5, score = 800
            //   6a3c                 | push                0x3c
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d842428030000       | lea                 eax, [esp + 0x328]

        $sequence_9 = { c7868c00000000000000 7711 c786f800000003000000 32c0 e9???????? 33c9 c78424d000000007000000 }
            // n = 7, score = 800
            //   c7868c00000000000000     | mov    dword ptr [esi + 0x8c], 0
            //   7711                 | ja                  0x13
            //   c786f800000003000000     | mov    dword ptr [esi + 0xf8], 3
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   c78424d000000007000000     | mov    dword ptr [esp + 0xd0], 7

    condition:
        7 of them and filesize < 368640
}