rule win_cloudeye_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cloudeye."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cloudeye"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 64ff35c0000000 8f4548 c3 60 b055 }
            // n = 5, score = 100
            //   64ff35c0000000       | push                dword ptr fs:[0xc0]
            //   8f4548               | pop                 dword ptr [ebp + 0x48]
            //   c3                   | ret                 
            //   60                   | pushal              
            //   b055                 | mov                 al, 0x55

        $sequence_1 = { c70010000100 80fc8b ffb700500000 39c9 6afe ff5528 }
            // n = 6, score = 100
            //   c70010000100         | mov                 dword ptr [eax], 0x10010
            //   80fc8b               | cmp                 ah, 0x8b
            //   ffb700500000         | push                dword ptr [edi + 0x5000]
            //   39c9                 | cmp                 ecx, ecx
            //   6afe                 | push                -2
            //   ff5528               | call                dword ptr [ebp + 0x28]

        $sequence_2 = { 85da 8b4d18 bafee5190e e8???????? }
            // n = 4, score = 100
            //   85da                 | test                edx, ebx
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   bafee5190e           | mov                 edx, 0xe19e5fe
            //   e8????????           |                     

        $sequence_3 = { 7570 206b65 7900 e8???????? 53 }
            // n = 5, score = 100
            //   7570                 | jne                 0x72
            //   206b65               | and                 byte ptr [ebx + 0x65], ch
            //   7900                 | jns                 2
            //   e8????????           |                     
            //   53                   | push                ebx

        $sequence_4 = { ff50e0 6639d1 61 b8ffffffff }
            // n = 4, score = 100
            //   ff50e0               | call                dword ptr [eax - 0x20]
            //   6639d1               | cmp                 cx, dx
            //   61                   | popal               
            //   b8ffffffff           | mov                 eax, 0xffffffff

        $sequence_5 = { 83f800 0f8598000000 6685c1 8b4d20 81c100410000 c70107000100 51 }
            // n = 7, score = 100
            //   83f800               | cmp                 eax, 0
            //   0f8598000000         | jne                 0x9e
            //   6685c1               | test                cx, ax
            //   8b4d20               | mov                 ecx, dword ptr [ebp + 0x20]
            //   81c100410000         | add                 ecx, 0x4100
            //   c70107000100         | mov                 dword ptr [ecx], 0x10007
            //   51                   | push                ecx

        $sequence_6 = { 81c29c000000 52 6a07 6aff 38ed 50 e8???????? }
            // n = 7, score = 100
            //   81c29c000000         | add                 edx, 0x9c
            //   52                   | push                edx
            //   6a07                 | push                7
            //   6aff                 | push                -1
            //   38ed                 | cmp                 ch, ch
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_7 = { 5b 6685da 31c0 83c004 }
            // n = 4, score = 100
            //   5b                   | pop                 ebx
            //   6685da               | test                dx, bx
            //   31c0                 | xor                 eax, eax
            //   83c004               | add                 eax, 4

        $sequence_8 = { 8bb714080000 38ef 8b8700080000 01f0 01c8 }
            // n = 5, score = 100
            //   8bb714080000         | mov                 esi, dword ptr [edi + 0x814]
            //   38ef                 | cmp                 bh, ch
            //   8b8700080000         | mov                 eax, dword ptr [edi + 0x800]
            //   01f0                 | add                 eax, esi
            //   01c8                 | add                 eax, ecx

        $sequence_9 = { 85db 837d7401 750a e8???????? 83f801 7405 }
            // n = 6, score = 100
            //   85db                 | test                ebx, ebx
            //   837d7401             | cmp                 dword ptr [ebp + 0x74], 1
            //   750a                 | jne                 0xc
            //   e8????????           |                     
            //   83f801               | cmp                 eax, 1
            //   7405                 | je                  7

    condition:
        7 of them and filesize < 90112
}