rule win_confucius_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.confucius."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.confucius"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0101 eb11 8b442424 50 }
            // n = 4, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   eb11                 | jmp                 0x13
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   50                   | push                eax

        $sequence_1 = { 8b45f8 33c9 66898c45d0f7ffff 6639bdd0f7ffff 7428 }
            // n = 5, score = 100
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   33c9                 | xor                 ecx, ecx
            //   66898c45d0f7ffff     | mov                 word ptr [ebp + eax*2 - 0x830], cx
            //   6639bdd0f7ffff       | cmp                 word ptr [ebp - 0x830], di
            //   7428                 | je                  0x2a

        $sequence_2 = { 884710 5f 5e c9 c3 }
            // n = 5, score = 100
            //   884710               | mov                 byte ptr [edi + 0x10], al
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_3 = { 85c0 0f85df020000 e8???????? 33f6 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   0f85df020000         | jne                 0x2e5
            //   e8????????           |                     
            //   33f6                 | xor                 esi, esi

        $sequence_4 = { a3???????? 83ffff 7519 833d????????00 7510 }
            // n = 5, score = 100
            //   a3????????           |                     
            //   83ffff               | cmp                 edi, -1
            //   7519                 | jne                 0x1b
            //   833d????????00       |                     
            //   7510                 | jne                 0x12

        $sequence_5 = { 750f 0fb74604 6683f82c 740c 6685c0 }
            // n = 5, score = 100
            //   750f                 | jne                 0x11
            //   0fb74604             | movzx               eax, word ptr [esi + 4]
            //   6683f82c             | cmp                 ax, 0x2c
            //   740c                 | je                  0xe
            //   6685c0               | test                ax, ax

        $sequence_6 = { 01460c 8b44240c 85c0 7402 }
            // n = 4, score = 100
            //   01460c               | add                 dword ptr [esi + 0xc], eax
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   85c0                 | test                eax, eax
            //   7402                 | je                  4

        $sequence_7 = { 0203 0405 0206 07 089090909090 }
            // n = 5, score = 100
            //   0203                 | add                 al, byte ptr [ebx]
            //   0405                 | add                 al, 5
            //   0206                 | add                 al, byte ptr [esi]
            //   07                   | pop                 es
            //   089090909090         | or                  byte ptr [eax - 0x6f6f6f70], dl

        $sequence_8 = { 0103 33c0 5f 5e 5d }
            // n = 5, score = 100
            //   0103                 | add                 dword ptr [ebx], eax
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_9 = { 8d85d0f7ffff 50 8d85288fffff 50 56 }
            // n = 5, score = 100
            //   8d85d0f7ffff         | lea                 eax, [ebp - 0x830]
            //   50                   | push                eax
            //   8d85288fffff         | lea                 eax, [ebp - 0x70d8]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_10 = { 00801d430023 d18a0688078a 46 018847018a46 }
            // n = 4, score = 100
            //   00801d430023         | add                 byte ptr [eax + 0x2300431d], al
            //   d18a0688078a         | ror                 dword ptr [edx - 0x75f877fa], 1
            //   46                   | inc                 esi
            //   018847018a46         | add                 dword ptr [eax + 0x468a0147], ecx

        $sequence_11 = { 0101 eb21 8b4c2420 c744241000000000 }
            // n = 4, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   eb21                 | jmp                 0x23
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0

        $sequence_12 = { 51 51 830d????????ff 53 55 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   830d????????ff       |                     
            //   53                   | push                ebx
            //   55                   | push                ebp

        $sequence_13 = { 0344242c 8d940297ff2a43 8bc2 c1e816 }
            // n = 4, score = 100
            //   0344242c             | add                 eax, dword ptr [esp + 0x2c]
            //   8d940297ff2a43       | lea                 edx, [edx + eax + 0x432aff97]
            //   8bc2                 | mov                 eax, edx
            //   c1e816               | shr                 eax, 0x16

        $sequence_14 = { 018118030000 8b442410 8b4c2420 5f }
            // n = 4, score = 100
            //   018118030000         | add                 dword ptr [ecx + 0x318], eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   5f                   | pop                 edi

        $sequence_15 = { 030b 51 50 ff15???????? }
            // n = 4, score = 100
            //   030b                 | add                 ecx, dword ptr [ebx]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 598016
}