rule win_coronavirus_ransomware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.coronavirus_ransomware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.coronavirus_ransomware"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6685c9 75f5 56 2bc2 57 8b7df8 d1f8 }
            // n = 7, score = 100
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   56                   | push                esi
            //   2bc2                 | sub                 eax, edx
            //   57                   | push                edi
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   d1f8                 | sar                 eax, 1

        $sequence_1 = { 56 50 89742474 89742478 e8???????? }
            // n = 5, score = 100
            //   56                   | push                esi
            //   50                   | push                eax
            //   89742474             | mov                 dword ptr [esp + 0x74], esi
            //   89742478             | mov                 dword ptr [esp + 0x78], esi
            //   e8????????           |                     

        $sequence_2 = { 8bf0 83feff 7424 85f6 7420 }
            // n = 5, score = 100
            //   8bf0                 | mov                 esi, eax
            //   83feff               | cmp                 esi, -1
            //   7424                 | je                  0x26
            //   85f6                 | test                esi, esi
            //   7420                 | je                  0x22

        $sequence_3 = { 7e58 a1???????? 50 e8???????? 8b0d???????? 83c404 6aff }
            // n = 7, score = 100
            //   7e58                 | jle                 0x5a
            //   a1????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   83c404               | add                 esp, 4
            //   6aff                 | push                -1

        $sequence_4 = { 895004 8bfb 8b1d???????? 68???????? 66894808 c745f400000000 ff15???????? }
            // n = 7, score = 100
            //   895004               | mov                 dword ptr [eax + 4], edx
            //   8bfb                 | mov                 edi, ebx
            //   8b1d????????         |                     
            //   68????????           |                     
            //   66894808             | mov                 word ptr [eax + 8], cx
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   ff15????????         |                     

        $sequence_5 = { 8b442414 8bd0 2b54bc5c 83fa01 750c 47 8944bc5c }
            // n = 7, score = 100
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   8bd0                 | mov                 edx, eax
            //   2b54bc5c             | sub                 edx, dword ptr [esp + edi*4 + 0x5c]
            //   83fa01               | cmp                 edx, 1
            //   750c                 | jne                 0xe
            //   47                   | inc                 edi
            //   8944bc5c             | mov                 dword ptr [esp + edi*4 + 0x5c], eax

        $sequence_6 = { 40 ebeb e8???????? 8b75a0 e9???????? }
            // n = 5, score = 100
            //   40                   | inc                 eax
            //   ebeb                 | jmp                 0xffffffed
            //   e8????????           |                     
            //   8b75a0               | mov                 esi, dword ptr [ebp - 0x60]
            //   e9????????           |                     

        $sequence_7 = { 51 833d????????00 c745fc00000000 752d b8???????? }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   833d????????00       |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   752d                 | jne                 0x2f
            //   b8????????           |                     

        $sequence_8 = { e8???????? 035dc4 807d0802 8b7dc8 0f8583000000 807d0c01 757d }
            // n = 7, score = 100
            //   e8????????           |                     
            //   035dc4               | add                 ebx, dword ptr [ebp - 0x3c]
            //   807d0802             | cmp                 byte ptr [ebp + 8], 2
            //   8b7dc8               | mov                 edi, dword ptr [ebp - 0x38]
            //   0f8583000000         | jne                 0x89
            //   807d0c01             | cmp                 byte ptr [ebp + 0xc], 1
            //   757d                 | jne                 0x7f

        $sequence_9 = { 84c0 7426 0fb60d???????? 0fb6c0 0fb68080fa4000 03c1 }
            // n = 6, score = 100
            //   84c0                 | test                al, al
            //   7426                 | je                  0x28
            //   0fb60d????????       |                     
            //   0fb6c0               | movzx               eax, al
            //   0fb68080fa4000       | movzx               eax, byte ptr [eax + 0x40fa80]
            //   03c1                 | add                 eax, ecx

    condition:
        7 of them and filesize < 235520
}