rule win_crackedcantil_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.crackedcantil."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crackedcantil"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff3424 5b 4881ec08000000 48891424 4889e2 4883c208 4881c208000000 }
            // n = 7, score = 100
            //   ff3424               | push                0x1bb693ad
            //   5b                   | dec                 eax
            //   4881ec08000000       | sub                 esp, 0x18
            //   48891424             | push                0x4a2c73b8
            //   4889e2               | inc                 word ptr [esp + 6]
            //   4883c208             | mov                 eax, 0x10b0
            //   4881c208000000       | dec                 eax

        $sequence_1 = { eb7e 488b842490000000 0f57c0 f20f1100 eb6d 488b842490000000 48c70000000000 }
            // n = 7, score = 100
            //   eb7e                 | xor                 eax, eax
            //   488b842490000000     | mov                 edx, 0x49
            //   0f57c0               | dec                 eax
            //   f20f1100             | mov                 ecx, dword ptr [esp + 0xa0]
            //   eb6d                 | mov                 ecx, dword ptr [esp + 0x98]
            //   488b842490000000     | mov                 dword ptr [esp + 0x28], ecx
            //   48c70000000000       | mov                 dword ptr [esp + 0x20], 0

        $sequence_2 = { f30f7f00 488b8424f0060000 48898424f00a0000 488b9424f00a0000 488b8c24c8000000 e8???????? 488905???????? }
            // n = 7, score = 100
            //   f30f7f00             | dec                 eax
            //   488b8424f0060000     | lea                 eax, [esp + 0x578]
            //   48898424f00a0000     | dec                 eax
            //   488b9424f00a0000     | mov                 dword ptr [esp + 0x2f8], eax
            //   488b8c24c8000000     | movzx               edx, byte ptr [esp + 0x570]
            //   e8????????           |                     
            //   488905????????       |                     

        $sequence_3 = { f3aa 488d8424c0430000 48898424f0130000 488d152df22c00 488b8c24f0130000 e8???????? 48898424f8130000 }
            // n = 7, score = 100
            //   f3aa                 | dec                 eax
            //   488d8424c0430000     | mov                 edx, dword ptr [esp + 0x18]
            //   48898424f0130000     | dec                 eax
            //   488d152df22c00       | mov                 dword ptr [ecx + eax], edx
            //   488b8c24f0130000     | dec                 eax
            //   e8????????           |                     
            //   48898424f8130000     | mov                 eax, dword ptr [esp + 0x10]

        $sequence_4 = { ffc0 488b4c2440 8901 b801000000 eb15 48837c244800 740b }
            // n = 7, score = 100
            //   ffc0                 | movzx               eax, byte ptr [esp + 0x7c]
            //   488b4c2440           | mov                 byte ptr [esp + 0x4a0], al
            //   8901                 | movzx               eax, byte ptr [esp + 0x7d]
            //   b801000000           | mov                 ecx, 1
            //   eb15                 | rep stosb           byte ptr es:[edi], al
            //   48837c244800         | movzx               eax, byte ptr [esp + 0x7b]
            //   740b                 | mov                 byte ptr [esp + 0x3a0], al

        $sequence_5 = { e8???????? 4889442470 c744244000000000 eb0a 8b442440 ffc0 89442440 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889442470           | dec                 eax
            //   c744244000000000     | mov                 dword ptr [esp + 0x58], eax
            //   eb0a                 | mov                 dword ptr [esp + 0x40], eax
            //   8b442440             | dec                 eax
            //   ffc0                 | mov                 eax, dword ptr [esp + 0xa8]
            //   89442440             | dec                 eax

        $sequence_6 = { f3a4 488d542450 488b8c2480000000 e8???????? 90 488b842480000000 4883c468 }
            // n = 7, score = 100
            //   f3a4                 | dec                 eax
            //   488d542450           | lea                 eax, [esp + 0x1c7]
            //   488b8c2480000000     | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 edi, eax
            //   488b842480000000     | xor                 eax, eax
            //   4883c468             | mov                 ecx, 1

        $sequence_7 = { ff742410 ff3424 ff3424 5b 4881c408000000 4881c408000000 688fdfbf7d }
            // n = 7, score = 100
            //   ff742410             | movdqa              xmmword ptr [esp + 0x1610], xmm0
            //   ff3424               | dec                 eax
            //   ff3424               | mov                 eax, dword ptr [esp + 0x648]
            //   5b                   | mov                 ecx, 1
            //   4881c408000000       | rep stosb           byte ptr es:[edi], al
            //   4881c408000000       | movzx               eax, byte ptr [esp + 0x42]
            //   688fdfbf7d           | mov                 byte ptr [esp + 0x230], al

        $sequence_8 = { e8???????? 90 488d8c24b0130000 e8???????? 90 488d8c24d0130000 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | mov                 word ptr [ecx + eax*4 + 2], dx
            //   488d8c24b0130000     | mov                 eax, dword ptr [esp + 0xc]
            //   e8????????           |                     
            //   90                   | inc                 eax
            //   488d8c24d0130000     | mov                 dword ptr [esp + 0xc], eax
            //   e8????????           |                     

        $sequence_9 = { f3aa 488d05e9923200 4889842450040000 488b842450040000 488bc8 e8???????? 488d05ca923200 }
            // n = 7, score = 100
            //   f3aa                 | add                 ecx, dword ptr [esp + eax + 0x3e8]
            //   488d05e9923200       | mov                 eax, ecx
            //   4889842450040000     | mov                 eax, 4
            //   488b842450040000     | dec                 eax
            //   488bc8               | imul                eax, eax, 7
            //   e8????????           |                     
            //   488d05ca923200       | mov                 ecx, 4

    condition:
        7 of them and filesize < 37863424
}