rule win_crenufs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.crenufs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crenufs"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4dac 53 51 ff75ec }
            // n = 4, score = 200
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   ff75ec               | push                dword ptr [ebp - 0x14]

        $sequence_1 = { 8d442410 6a00 50 8d4e10 6a04 51 52 }
            // n = 7, score = 200
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8d4e10               | lea                 ecx, [esi + 0x10]
            //   6a04                 | push                4
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_2 = { 85c0 751b 3b742414 741b 0fbe4eff 4e 57 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   751b                 | jne                 0x1d
            //   3b742414             | cmp                 esi, dword ptr [esp + 0x14]
            //   741b                 | je                  0x1d
            //   0fbe4eff             | movsx               ecx, byte ptr [esi - 1]
            //   4e                   | dec                 esi
            //   57                   | push                edi

        $sequence_3 = { 800d????????01 53 8bce a2???????? ff15???????? 68???????? }
            // n = 6, score = 200
            //   800d????????01       |                     
            //   53                   | push                ebx
            //   8bce                 | mov                 ecx, esi
            //   a2????????           |                     
            //   ff15????????         |                     
            //   68????????           |                     

        $sequence_4 = { 57 50 ffd5 8b0f 41 51 e8???????? }
            // n = 7, score = 200
            //   57                   | push                edi
            //   50                   | push                eax
            //   ffd5                 | call                ebp
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   41                   | inc                 ecx
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_5 = { 3beb 0f84fd010000 8b44244c 8b4d00 3bc8 7408 }
            // n = 6, score = 200
            //   3beb                 | cmp                 ebp, ebx
            //   0f84fd010000         | je                  0x203
            //   8b44244c             | mov                 eax, dword ptr [esp + 0x4c]
            //   8b4d00               | mov                 ecx, dword ptr [ebp]
            //   3bc8                 | cmp                 ecx, eax
            //   7408                 | je                  0xa

        $sequence_6 = { 8dbe1a040000 57 ff7604 ff15???????? }
            // n = 4, score = 200
            //   8dbe1a040000         | lea                 edi, [esi + 0x41a]
            //   57                   | push                edi
            //   ff7604               | push                dword ptr [esi + 4]
            //   ff15????????         |                     

        $sequence_7 = { f3aa 8b4e58 8b565c 8d442414 50 8b4304 51 }
            // n = 7, score = 200
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   8b4e58               | mov                 ecx, dword ptr [esi + 0x58]
            //   8b565c               | mov                 edx, dword ptr [esi + 0x5c]
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   51                   | push                ecx

        $sequence_8 = { 8a450b 56 57 6a00 }
            // n = 4, score = 200
            //   8a450b               | mov                 al, byte ptr [ebp + 0xb]
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a00                 | push                0

        $sequence_9 = { 52 50 ffd5 8b4338 85c0 7505 897338 }
            // n = 7, score = 200
            //   52                   | push                edx
            //   50                   | push                eax
            //   ffd5                 | call                ebp
            //   8b4338               | mov                 eax, dword ptr [ebx + 0x38]
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   897338               | mov                 dword ptr [ebx + 0x38], esi

    condition:
        7 of them and filesize < 106496
}