rule win_crutch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.crutch."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crutch"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3944240c 0f8523060000 837e5800 0f84cb000000 8d442418 50 8d4c2408 }
            // n = 7, score = 100
            //   3944240c             | cmp                 dword ptr [esp + 0xc], eax
            //   0f8523060000         | jne                 0x629
            //   837e5800             | cmp                 dword ptr [esi + 0x58], 0
            //   0f84cb000000         | je                  0xd1
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax
            //   8d4c2408             | lea                 ecx, [esp + 8]

        $sequence_1 = { 85c0 0f85bc000000 8b4c2458 6a00 6a00 8d86604b0000 50 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f85bc000000         | jne                 0xc2
            //   8b4c2458             | mov                 ecx, dword ptr [esp + 0x58]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d86604b0000         | lea                 eax, [esi + 0x4b60]
            //   50                   | push                eax

        $sequence_2 = { c60730 4f 4e 85d2 7e0f 2bf2 }
            // n = 6, score = 100
            //   c60730               | mov                 byte ptr [edi], 0x30
            //   4f                   | dec                 edi
            //   4e                   | dec                 esi
            //   85d2                 | test                edx, edx
            //   7e0f                 | jle                 0x11
            //   2bf2                 | sub                 esi, edx

        $sequence_3 = { 8944241c 8944242c 83f901 7507 b9???????? eb0f 83f902 }
            // n = 7, score = 100
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   83f901               | cmp                 ecx, 1
            //   7507                 | jne                 9
            //   b9????????           |                     
            //   eb0f                 | jmp                 0x11
            //   83f902               | cmp                 ecx, 2

        $sequence_4 = { 07 08cc 8b442404 56 8bb088050000 85f6 7438 }
            // n = 7, score = 100
            //   07                   | pop                 es
            //   08cc                 | or                  ah, cl
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   56                   | push                esi
            //   8bb088050000         | mov                 esi, dword ptr [eax + 0x588]
            //   85f6                 | test                esi, esi
            //   7438                 | je                  0x3a

        $sequence_5 = { 8b742424 8b9660060000 83ec10 8bcc 8911 8b9664060000 895104 }
            // n = 7, score = 100
            //   8b742424             | mov                 esi, dword ptr [esp + 0x24]
            //   8b9660060000         | mov                 edx, dword ptr [esi + 0x660]
            //   83ec10               | sub                 esp, 0x10
            //   8bcc                 | mov                 ecx, esp
            //   8911                 | mov                 dword ptr [ecx], edx
            //   8b9664060000         | mov                 edx, dword ptr [esi + 0x664]
            //   895104               | mov                 dword ptr [ecx + 4], edx

        $sequence_6 = { 899ee8020000 e8???????? 8bf8 5f 33db 5b }
            // n = 6, score = 100
            //   899ee8020000         | mov                 dword ptr [esi + 0x2e8], ebx
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   5f                   | pop                 edi
            //   33db                 | xor                 ebx, ebx
            //   5b                   | pop                 ebx

        $sequence_7 = { 0f85ab000000 837dec00 0f84a1000000 8b55f4 8b049588980710 f644180448 7452 }
            // n = 7, score = 100
            //   0f85ab000000         | jne                 0xb1
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   0f84a1000000         | je                  0xa7
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b049588980710       | mov                 eax, dword ptr [edx*4 + 0x10079888]
            //   f644180448           | test                byte ptr [eax + ebx + 4], 0x48
            //   7452                 | je                  0x54

        $sequence_8 = { 8db0f04b0000 8937 e8???????? 8906 c7460400000000 85db 743b }
            // n = 7, score = 100
            //   8db0f04b0000         | lea                 esi, [eax + 0x4bf0]
            //   8937                 | mov                 dword ptr [edi], esi
            //   e8????????           |                     
            //   8906                 | mov                 dword ptr [esi], eax
            //   c7460400000000       | mov                 dword ptr [esi + 4], 0
            //   85db                 | test                ebx, ebx
            //   743b                 | je                  0x3d

        $sequence_9 = { 5d c3 6a6c b8???????? e8???????? 8bf9 83ec18 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   6a6c                 | push                0x6c
            //   b8????????           |                     
            //   e8????????           |                     
            //   8bf9                 | mov                 edi, ecx
            //   83ec18               | sub                 esp, 0x18

    condition:
        7 of them and filesize < 1067008
}