rule win_cryakl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryakl"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b45dc e8???????? 8bd8 8d55dc 8b45fc e8???????? }
            // n = 7, score = 300
            //   e8????????           |                     
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   8d55dc               | lea                 edx, [ebp - 0x24]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     

        $sequence_1 = { 8d45e0 e8???????? eb11 8d45e8 50 }
            // n = 5, score = 300
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   e8????????           |                     
            //   eb11                 | jmp                 0x13
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax

        $sequence_2 = { e8???????? 807dd601 750a c60600 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   807dd601             | cmp                 byte ptr [ebp - 0x2a], 1
            //   750a                 | jne                 0xc
            //   c60600               | mov                 byte ptr [esi], 0

        $sequence_3 = { 8d45e0 e8???????? 8b4604 8b55cc 33c9 890c90 }
            // n = 6, score = 300
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   e8????????           |                     
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   8b55cc               | mov                 edx, dword ptr [ebp - 0x34]
            //   33c9                 | xor                 ecx, ecx
            //   890c90               | mov                 dword ptr [eax + edx*4], ecx

        $sequence_4 = { e8???????? 8d45e8 e8???????? 4e 0f850affffff }
            // n = 5, score = 300
            //   e8????????           |                     
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   e8????????           |                     
            //   4e                   | dec                 esi
            //   0f850affffff         | jne                 0xffffff10

        $sequence_5 = { 8d45e8 e8???????? eb10 8d45d4 }
            // n = 4, score = 300
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   e8????????           |                     
            //   eb10                 | jmp                 0x12
            //   8d45d4               | lea                 eax, [ebp - 0x2c]

        $sequence_6 = { e8???????? 807dd700 7565 8d55e8 8bc3 e8???????? 3c02 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   807dd700             | cmp                 byte ptr [ebp - 0x29], 0
            //   7565                 | jne                 0x67
            //   8d55e8               | lea                 edx, [ebp - 0x18]
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   3c02                 | cmp                 al, 2

        $sequence_7 = { 8d55d8 8d45e0 e8???????? 8d45d8 }
            // n = 4, score = 300
            //   8d55d8               | lea                 edx, [ebp - 0x28]
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   e8????????           |                     
            //   8d45d8               | lea                 eax, [ebp - 0x28]

    condition:
        7 of them and filesize < 917504
}