rule win_cryptoluck_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cryptoluck."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptoluck"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83bd3cefffff00 7429 8b8544efffff c60000 8b8d44efffff 83c101 }
            // n = 6, score = 100
            //   83bd3cefffff00       | cmp                 dword ptr [ebp - 0x10c4], 0
            //   7429                 | je                  0x2b
            //   8b8544efffff         | mov                 eax, dword ptr [ebp - 0x10bc]
            //   c60000               | mov                 byte ptr [eax], 0
            //   8b8d44efffff         | mov                 ecx, dword ptr [ebp - 0x10bc]
            //   83c101               | add                 ecx, 1

        $sequence_1 = { 8b4df8 894de4 8b55fc 8955e8 837de400 }
            // n = 5, score = 100
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8955e8               | mov                 dword ptr [ebp - 0x18], edx
            //   837de400             | cmp                 dword ptr [ebp - 0x1c], 0

        $sequence_2 = { 8b4dec 83c101 894dec 833d????????00 740e 33d2 }
            // n = 6, score = 100
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   83c101               | add                 ecx, 1
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   833d????????00       |                     
            //   740e                 | je                  0x10
            //   33d2                 | xor                 edx, edx

        $sequence_3 = { 8d55d8 52 6a00 6819000200 }
            // n = 4, score = 100
            //   8d55d8               | lea                 edx, [ebp - 0x28]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   6819000200           | push                0x20019

        $sequence_4 = { 8945f8 837df800 0f84d3000000 8b55f8 }
            // n = 4, score = 100
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   0f84d3000000         | je                  0xd9
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_5 = { ff15???????? b801000000 e9???????? 8d4dd8 51 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   b801000000           | mov                 eax, 1
            //   e9????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   51                   | push                ecx

        $sequence_6 = { c1ea03 83ea0b 8b4514 8910 c745f801000000 eb0c }
            // n = 6, score = 100
            //   c1ea03               | shr                 edx, 3
            //   83ea0b               | sub                 edx, 0xb
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   8910                 | mov                 dword ptr [eax], edx
            //   c745f801000000       | mov                 dword ptr [ebp - 8], 1
            //   eb0c                 | jmp                 0xe

        $sequence_7 = { eb02 eb0a 837df400 0f848bfeffff 8b5518 8b45f8 }
            // n = 6, score = 100
            //   eb02                 | jmp                 4
            //   eb0a                 | jmp                 0xc
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   0f848bfeffff         | je                  0xfffffe91
            //   8b5518               | mov                 edx, dword ptr [ebp + 0x18]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_8 = { c785acf6ffff00000000 8d85acf6ffff 50 8d8da4f6ffff 51 8d95a0f6ffff }
            // n = 6, score = 100
            //   c785acf6ffff00000000     | mov    dword ptr [ebp - 0x954], 0
            //   8d85acf6ffff         | lea                 eax, [ebp - 0x954]
            //   50                   | push                eax
            //   8d8da4f6ffff         | lea                 ecx, [ebp - 0x95c]
            //   51                   | push                ecx
            //   8d95a0f6ffff         | lea                 edx, [ebp - 0x960]

        $sequence_9 = { 8bec 83ec3c 8b4508 a3???????? 8b4d0c }
            // n = 5, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec3c               | sub                 esp, 0x3c
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   a3????????           |                     
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

    condition:
        7 of them and filesize < 229376
}