rule win_dairy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dairy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dairy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 51 ff15???????? 85c0 741a e9???????? }
            // n = 6, score = 100
            //   52                   | push                edx
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   741a                 | je                  0x1c
            //   e9????????           |                     

        $sequence_1 = { 6a61 b932000000 33c0 8dbc2480030000 6a74 6a61 6a64 }
            // n = 7, score = 100
            //   6a61                 | push                0x61
            //   b932000000           | mov                 ecx, 0x32
            //   33c0                 | xor                 eax, eax
            //   8dbc2480030000       | lea                 edi, [esp + 0x380]
            //   6a74                 | push                0x74
            //   6a61                 | push                0x61
            //   6a64                 | push                0x64

        $sequence_2 = { 8b0d???????? 56 ff5110 8b542414 }
            // n = 4, score = 100
            //   8b0d????????         |                     
            //   56                   | push                esi
            //   ff5110               | call                dword ptr [ecx + 0x10]
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]

        $sequence_3 = { 53 8b5c2410 55 56 57 8bfb 33f6 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   8b5c2410             | mov                 ebx, dword ptr [esp + 0x10]
            //   55                   | push                ebp
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bfb                 | mov                 edi, ebx
            //   33f6                 | xor                 esi, esi

        $sequence_4 = { 51 e8???????? 83c418 85c0 0f8e4f010000 8b550c 6800040000 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   0f8e4f010000         | jle                 0x155
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   6800040000           | push                0x400

        $sequence_5 = { b900020000 33c0 8dbc2420020000 f3ab }
            // n = 4, score = 100
            //   b900020000           | mov                 ecx, 0x200
            //   33c0                 | xor                 eax, eax
            //   8dbc2420020000       | lea                 edi, [esp + 0x220]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_6 = { 68???????? 51 e8???????? 83c40c 85c0 0f85bb000000 }
            // n = 6, score = 100
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f85bb000000         | jne                 0xc1

        $sequence_7 = { 0f8ecefeffff bf???????? 83c9ff 33c0 f2ae f7d1 49 }
            // n = 7, score = 100
            //   0f8ecefeffff         | jle                 0xfffffed4
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx

        $sequence_8 = { 55 56 8b742420 8b44241c }
            // n = 4, score = 100
            //   55                   | push                ebp
            //   56                   | push                esi
            //   8b742420             | mov                 esi, dword ptr [esp + 0x20]
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]

        $sequence_9 = { 7437 8b442448 6a40 50 ffd6 }
            // n = 5, score = 100
            //   7437                 | je                  0x39
            //   8b442448             | mov                 eax, dword ptr [esp + 0x48]
            //   6a40                 | push                0x40
            //   50                   | push                eax
            //   ffd6                 | call                esi

    condition:
        7 of them and filesize < 212992
}