rule win_darkpulsar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.darkpulsar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkpulsar"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 40 c20c00 68???????? 64ff3500000000 8b442410 896c2410 }
            // n = 7, score = 600
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   c20c00               | ret                 0xc
            //   68????????           |                     
            //   64ff3500000000       | push                dword ptr fs:[0]
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   896c2410             | mov                 dword ptr [esp + 0x10], ebp

        $sequence_1 = { c21000 ff25???????? ff25???????? ff25???????? 33c0 }
            // n = 5, score = 600
            //   c21000               | ret                 0x10
            //   ff25????????         |                     
            //   ff25????????         |                     
            //   ff25????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 3a01 1bc0 83e0fe 40 5f 5e }
            // n = 6, score = 400
            //   3a01                 | cmp                 al, byte ptr [ecx]
            //   1bc0                 | sbb                 eax, eax
            //   83e0fe               | and                 eax, 0xfffffffe
            //   40                   | inc                 eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_3 = { 59 3bd8 74e0 0fb607 8b4d0c 3a01 }
            // n = 6, score = 300
            //   59                   | pop                 ecx
            //   3bd8                 | cmp                 ebx, eax
            //   74e0                 | je                  0xffffffe2
            //   0fb607               | movzx               eax, byte ptr [edi]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   3a01                 | cmp                 al, byte ptr [ecx]

        $sequence_4 = { 50 ffd6 8bd8 8b450c 0fbe00 50 ffd6 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8bd8                 | mov                 ebx, eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   0fbe00               | movsx               eax, byte ptr [eax]
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_5 = { 803f00 742e 47 ff450c 0fbe07 }
            // n = 5, score = 300
            //   803f00               | cmp                 byte ptr [edi], 0
            //   742e                 | je                  0x30
            //   47                   | inc                 edi
            //   ff450c               | inc                 dword ptr [ebp + 0xc]
            //   0fbe07               | movsx               eax, byte ptr [edi]

        $sequence_6 = { 50 ffd6 59 59 3bd8 74e0 }
            // n = 6, score = 300
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   3bd8                 | cmp                 ebx, eax
            //   74e0                 | je                  0xffffffe2

        $sequence_7 = { 56 8b35???????? 57 8b7d08 eb09 }
            // n = 5, score = 300
            //   56                   | push                esi
            //   8b35????????         |                     
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   eb09                 | jmp                 0xb

        $sequence_8 = { 8b5d10 56 8b7508 33d2 }
            // n = 4, score = 200
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   33d2                 | xor                 edx, edx

        $sequence_9 = { e8???????? 59 85c0 7625 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7625                 | jbe                 0x27

        $sequence_10 = { 33c0 eb03 83c8ff 5f 5e c3 56 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   eb03                 | jmp                 5
            //   83c8ff               | or                  eax, 0xffffffff
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   56                   | push                esi

        $sequence_11 = { 8bd8 53 e8???????? 83c410 85c0 750c }
            // n = 6, score = 200
            //   8bd8                 | mov                 ebx, eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe

        $sequence_12 = { 59 5e 8b45fc c9 }
            // n = 4, score = 200
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c9                   | leave               

        $sequence_13 = { 8d4601 6a01 50 ff15???????? 8bf8 }
            // n = 5, score = 200
            //   8d4601               | lea                 eax, [esi + 1]
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_14 = { 8d45cc 50 57 e8???????? 83c410 85c0 }
            // n = 6, score = 200
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax

        $sequence_15 = { 1bc0 59 40 c3 e9???????? }
            // n = 5, score = 200
            //   1bc0                 | sbb                 eax, eax
            //   59                   | pop                 ecx
            //   40                   | inc                 eax
            //   c3                   | ret                 
            //   e9????????           |                     

        $sequence_16 = { 5e c9 c3 56 8b742408 85f6 7412 }
            // n = 7, score = 200
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8b742408             | mov                 esi, dword ptr [esp + 8]
            //   85f6                 | test                esi, esi
            //   7412                 | je                  0x14

        $sequence_17 = { e8???????? 8bf0 46 56 ff15???????? 59 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   46                   | inc                 esi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   59                   | pop                 ecx

        $sequence_18 = { 50 ff7618 ff15???????? 59 59 85c0 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ff7618               | push                dword ptr [esi + 0x18]
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_19 = { 53 33d2 56 57 33c0 }
            // n = 5, score = 200
            //   53                   | push                ebx
            //   33d2                 | xor                 edx, edx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax

        $sequence_20 = { 5f 5e c3 8b442404 85c0 7503 }
            // n = 6, score = 200
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   85c0                 | test                eax, eax
            //   7503                 | jne                 5

        $sequence_21 = { 56 e8???????? ff742414 50 e8???????? }
            // n = 5, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_22 = { ff75fc ff75f4 e8???????? 59 59 83f8ff }
            // n = 6, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   83f8ff               | cmp                 eax, -1

        $sequence_23 = { 83c410 83f8ff 0f95c1 49 }
            // n = 4, score = 200
            //   83c410               | add                 esp, 0x10
            //   83f8ff               | cmp                 eax, -1
            //   0f95c1               | setne               cl
            //   49                   | dec                 ecx

        $sequence_24 = { 33d2 c3 8bff 55 8bec b863736de0 394508 }
            // n = 7, score = 200
            //   33d2                 | xor                 edx, edx
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   b863736de0           | mov                 eax, 0xe06d7363
            //   394508               | cmp                 dword ptr [ebp + 8], eax

        $sequence_25 = { ffd7 59 5f 5e c3 8b4c2404 85c9 }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]
            //   85c9                 | test                ecx, ecx

        $sequence_26 = { e8???????? 59 5e 83f8ff }
            // n = 4, score = 200
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   83f8ff               | cmp                 eax, -1

        $sequence_27 = { 6a01 ff15???????? 8bf0 59 59 3bf7 }
            // n = 6, score = 200
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   3bf7                 | cmp                 esi, edi

        $sequence_28 = { 8b4514 893e 897e04 894608 c7460c7f000000 }
            // n = 5, score = 100
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   893e                 | mov                 dword ptr [esi], edi
            //   897e04               | mov                 dword ptr [esi + 4], edi
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   c7460c7f000000       | mov                 dword ptr [esi + 0xc], 0x7f

        $sequence_29 = { 8d45f0 50 ff758c e8???????? 0fb606 }
            // n = 5, score = 100
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   ff758c               | push                dword ptr [ebp - 0x74]
            //   e8????????           |                     
            //   0fb606               | movzx               eax, byte ptr [esi]

        $sequence_30 = { 00db 7313 752f 3b742404 0f830b010000 }
            // n = 5, score = 100
            //   00db                 | add                 bl, bl
            //   7313                 | jae                 0x15
            //   752f                 | jne                 0x31
            //   3b742404             | cmp                 esi, dword ptr [esp + 4]
            //   0f830b010000         | jae                 0x111

        $sequence_31 = { 58 8b542408 85d2 7407 }
            // n = 4, score = 100
            //   58                   | pop                 eax
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   85d2                 | test                edx, edx
            //   7407                 | je                  9

        $sequence_32 = { 8b4d14 57 894628 894e08 e8???????? }
            // n = 5, score = 100
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   57                   | push                edi
            //   894628               | mov                 dword ptr [esi + 0x28], eax
            //   894e08               | mov                 dword ptr [esi + 8], ecx
            //   e8????????           |                     

        $sequence_33 = { 740a b8???????? e9???????? 56 be3412cdab }
            // n = 5, score = 100
            //   740a                 | je                  0xc
            //   b8????????           |                     
            //   e9????????           |                     
            //   56                   | push                esi
            //   be3412cdab           | mov                 esi, 0xabcd1234

        $sequence_34 = { 52 ff5640 85c0 0f8464010000 8b8690000000 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   ff5640               | call                dword ptr [esi + 0x40]
            //   85c0                 | test                eax, eax
            //   0f8464010000         | je                  0x16a
            //   8b8690000000         | mov                 eax, dword ptr [esi + 0x90]

        $sequence_35 = { 83f8ff 7446 8d85d8feffff 50 57 e8???????? }
            // n = 6, score = 100
            //   83f8ff               | cmp                 eax, -1
            //   7446                 | je                  0x48
            //   8d85d8feffff         | lea                 eax, [ebp - 0x128]
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_36 = { 6a03 50 e8???????? 83c414 eb19 8b570c }
            // n = 6, score = 100
            //   6a03                 | push                3
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   eb19                 | jmp                 0x1b
            //   8b570c               | mov                 edx, dword ptr [edi + 0xc]

        $sequence_37 = { 83c40c 85c0 7409 83f8fc 0f85af000000 8b45e8 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   83f8fc               | cmp                 eax, -4
            //   0f85af000000         | jne                 0xb5
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_38 = { e8???????? 83c40c c3 8b542404 8b4c2408 56 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c3                   | ret                 
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   56                   | push                esi

        $sequence_39 = { 00db 7313 75e1 3b742404 0f8318010000 }
            // n = 5, score = 100
            //   00db                 | add                 bl, bl
            //   7313                 | jae                 0x15
            //   75e1                 | jne                 0xffffffe3
            //   3b742404             | cmp                 esi, dword ptr [esp + 4]
            //   0f8318010000         | jae                 0x11e

        $sequence_40 = { c1ee08 8b75fc 885001 8bd1 0facf210 c1ee10 885002 }
            // n = 7, score = 100
            //   c1ee08               | shr                 esi, 8
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   885001               | mov                 byte ptr [eax + 1], dl
            //   8bd1                 | mov                 edx, ecx
            //   0facf210             | shrd                edx, esi, 0x10
            //   c1ee10               | shr                 esi, 0x10
            //   885002               | mov                 byte ptr [eax + 2], dl

        $sequence_41 = { 00db 73e1 7511 3b742404 }
            // n = 4, score = 100
            //   00db                 | add                 bl, bl
            //   73e1                 | jae                 0xffffffe3
            //   7511                 | jne                 0x13
            //   3b742404             | cmp                 esi, dword ptr [esp + 4]

        $sequence_42 = { 8975f8 8975e8 8975d0 8975dc }
            // n = 4, score = 100
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   8975e8               | mov                 dword ptr [ebp - 0x18], esi
            //   8975d0               | mov                 dword ptr [ebp - 0x30], esi
            //   8975dc               | mov                 dword ptr [ebp - 0x24], esi

        $sequence_43 = { 00db 7309 75f4 8a1e 46 10db }
            // n = 6, score = 100
            //   00db                 | add                 bl, bl
            //   7309                 | jae                 0xb
            //   75f4                 | jne                 0xfffffff6
            //   8a1e                 | mov                 bl, byte ptr [esi]
            //   46                   | inc                 esi
            //   10db                 | adc                 bl, bl

        $sequence_44 = { 8b35???????? 33db 53 6a04 8d45dc 50 57 }
            // n = 7, score = 100
            //   8b35????????         |                     
            //   33db                 | xor                 ebx, ebx
            //   53                   | push                ebx
            //   6a04                 | push                4
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_45 = { 50 ff7508 ff15???????? 83f8ff 741f 56 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   741f                 | je                  0x21
            //   56                   | push                esi

        $sequence_46 = { 8bf0 59 59 85f6 7423 ff75f0 }
            // n = 6, score = 100
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85f6                 | test                esi, esi
            //   7423                 | je                  0x25
            //   ff75f0               | push                dword ptr [ebp - 0x10]

        $sequence_47 = { 33c0 83c008 57 8b7d10 50 8907 894704 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   83c008               | add                 eax, 8
            //   57                   | push                edi
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   50                   | push                eax
            //   8907                 | mov                 dword ptr [edi], eax
            //   894704               | mov                 dword ptr [edi + 4], eax

        $sequence_48 = { 50 52 ff5624 85c0 0f84d2010000 31c0 50 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   52                   | push                edx
            //   ff5624               | call                dword ptr [esi + 0x24]
            //   85c0                 | test                eax, eax
            //   0f84d2010000         | je                  0x1d8
            //   31c0                 | xor                 eax, eax
            //   50                   | push                eax

        $sequence_49 = { 660fb64901 66c1e008 660bc1 c3 }
            // n = 4, score = 100
            //   660fb64901           | movzx               cx, byte ptr [ecx + 1]
            //   66c1e008             | shl                 ax, 8
            //   660bc1               | or                  ax, cx
            //   c3                   | ret                 

        $sequence_50 = { 51 d91c24 e8???????? 50 e8???????? d905???????? }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   d91c24               | fstp                dword ptr [esp]
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   d905????????         |                     

    condition:
        7 of them and filesize < 491520
}