rule win_darkshell_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.darkshell."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkshell"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 c744246044000000 ff15???????? 8be8 85ed 0f8494000000 }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   c744246044000000     | mov                 dword ptr [esp + 0x60], 0x44
            //   ff15????????         |                     
            //   8be8                 | mov                 ebp, eax
            //   85ed                 | test                ebp, ebp
            //   0f8494000000         | je                  0x9a

        $sequence_1 = { 8b542424 41 25ff0f0000 894c2410 8b0e 03c1 }
            // n = 6, score = 300
            //   8b542424             | mov                 edx, dword ptr [esp + 0x24]
            //   41                   | inc                 ecx
            //   25ff0f0000           | and                 eax, 0xfff
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   03c1                 | add                 eax, ecx

        $sequence_2 = { 8944240c 8d4c240c 89442410 51 89442418 52 50 }
            // n = 7, score = 300
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   51                   | push                ecx
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_3 = { 6681384d5a 7543 8b483c 03c1 813850450000 7536 8b4c2408 }
            // n = 7, score = 300
            //   6681384d5a           | cmp                 word ptr [eax], 0x5a4d
            //   7543                 | jne                 0x45
            //   8b483c               | mov                 ecx, dword ptr [eax + 0x3c]
            //   03c1                 | add                 eax, ecx
            //   813850450000         | cmp                 dword ptr [eax], 0x4550
            //   7536                 | jne                 0x38
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]

        $sequence_4 = { 5e 5b 8bc5 5f 5d 83c474 }
            // n = 6, score = 300
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8bc5                 | mov                 eax, ebp
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   83c474               | add                 esp, 0x74

        $sequence_5 = { c20400 8b15???????? 68???????? 52 c705????????01000000 ffd6 }
            // n = 6, score = 300
            //   c20400               | ret                 4
            //   8b15????????         |                     
            //   68????????           |                     
            //   52                   | push                edx
            //   c705????????01000000     |     
            //   ffd6                 | call                esi

        $sequence_6 = { d1ea 3bda 7286 8b4604 }
            // n = 4, score = 300
            //   d1ea                 | shr                 edx, 1
            //   3bda                 | cmp                 ebx, edx
            //   7286                 | jb                  0xffffff88
            //   8b4604               | mov                 eax, dword ptr [esi + 4]

        $sequence_7 = { 25ff000000 56 99 f7f9 8b74240c }
            // n = 5, score = 300
            //   25ff000000           | and                 eax, 0xff
            //   56                   | push                esi
            //   99                   | cdq                 
            //   f7f9                 | idiv                ecx
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]

        $sequence_8 = { 8b4c2414 52 8b542428 50 51 52 }
            // n = 6, score = 300
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   52                   | push                edx
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_9 = { 8b5008 33c0 8bfa f2ae }
            // n = 4, score = 300
            //   8b5008               | mov                 edx, dword ptr [eax + 8]
            //   33c0                 | xor                 eax, eax
            //   8bfa                 | mov                 edi, edx
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

    condition:
        7 of them and filesize < 344064
}