rule win_defray_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.defray."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.defray"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894704 8b45fc 8d0483 894708 }
            // n = 4, score = 200
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8d0483               | lea                 eax, [ebx + eax*4]
            //   894708               | mov                 dword ptr [edi + 8], eax

        $sequence_1 = { ab ab 66ab 33c0 8dbdb4faffff a5 a5 }
            // n = 7, score = 200
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   33c0                 | xor                 eax, eax
            //   8dbdb4faffff         | lea                 edi, [ebp - 0x54c]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_2 = { f78580cfffff00040000 0f85c0030000 8d85c0fdffff 50 ff15???????? 83f8ff }
            // n = 6, score = 200
            //   f78580cfffff00040000     | test    dword ptr [ebp - 0x3080], 0x400
            //   0f85c0030000         | jne                 0x3c6
            //   8d85c0fdffff         | lea                 eax, [ebp - 0x240]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1

        $sequence_3 = { 33c0 897dee 668945ec 66897df2 6a03 6a20 6a03 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   897dee               | mov                 dword ptr [ebp - 0x12], edi
            //   668945ec             | mov                 word ptr [ebp - 0x14], ax
            //   66897df2             | mov                 word ptr [ebp - 0xe], di
            //   6a03                 | push                3
            //   6a20                 | push                0x20
            //   6a03                 | push                3

        $sequence_4 = { 8d95a4f5ffff 8d8da4fdffff e8???????? 85c0 0f8e32010000 68ca050000 8d95a4f5ffff }
            // n = 7, score = 200
            //   8d95a4f5ffff         | lea                 edx, [ebp - 0xa5c]
            //   8d8da4fdffff         | lea                 ecx, [ebp - 0x25c]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8e32010000         | jle                 0x138
            //   68ca050000           | push                0x5ca
            //   8d95a4f5ffff         | lea                 edx, [ebp - 0xa5c]

        $sequence_5 = { 8bf0 33ff b9???????? 8d85accfffff 668b10 663b11 7523 }
            // n = 7, score = 200
            //   8bf0                 | mov                 esi, eax
            //   33ff                 | xor                 edi, edi
            //   b9????????           |                     
            //   8d85accfffff         | lea                 eax, [ebp - 0x3054]
            //   668b10               | mov                 dx, word ptr [eax]
            //   663b11               | cmp                 dx, word ptr [ecx]
            //   7523                 | jne                 0x25

        $sequence_6 = { a1???????? 33c5 50 8d45f4 64a300000000 eb24 8b048d00eb4800 }
            // n = 7, score = 200
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   eb24                 | jmp                 0x26
            //   8b048d00eb4800       | mov                 eax, dword ptr [ecx*4 + 0x48eb00]

        $sequence_7 = { 99 f7ff 8b7d08 8bd0 3bfa 766c b950077500 }
            // n = 7, score = 200
            //   99                   | cdq                 
            //   f7ff                 | idiv                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8bd0                 | mov                 edx, eax
            //   3bfa                 | cmp                 edi, edx
            //   766c                 | jbe                 0x6e
            //   b950077500           | mov                 ecx, 0x750750

        $sequence_8 = { a1???????? 8d9598f9ffff 8907 8bf2 668b02 83c202 663bc1 }
            // n = 7, score = 200
            //   a1????????           |                     
            //   8d9598f9ffff         | lea                 edx, [ebp - 0x668]
            //   8907                 | mov                 dword ptr [edi], eax
            //   8bf2                 | mov                 esi, edx
            //   668b02               | mov                 ax, word ptr [edx]
            //   83c202               | add                 edx, 2
            //   663bc1               | cmp                 ax, cx

        $sequence_9 = { ba05000000 8d0da0564700 e9???????? a90000f07f 752c a9ffff0f00 7525 }
            // n = 7, score = 200
            //   ba05000000           | mov                 edx, 5
            //   8d0da0564700         | lea                 ecx, [0x4756a0]
            //   e9????????           |                     
            //   a90000f07f           | test                eax, 0x7ff00000
            //   752c                 | jne                 0x2e
            //   a9ffff0f00           | test                eax, 0xfffff
            //   7525                 | jne                 0x27

    condition:
        7 of them and filesize < 1253376
}