rule win_dexter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dexter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dexter"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b801000000 eb0d 8b4dfc 83c101 894dfc ebc8 33c0 }
            // n = 7, score = 400
            //   b801000000           | mov                 eax, 1
            //   eb0d                 | jmp                 0xf
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c101               | add                 ecx, 1
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   ebc8                 | jmp                 0xffffffca
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 68???????? 68???????? e8???????? 83c40c 68???????? a1???????? 50 }
            // n = 7, score = 400
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     
            //   a1????????           |                     
            //   50                   | push                eax

        $sequence_2 = { e8???????? 83c410 8b4508 50 8b4d10 }
            // n = 5, score = 400
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]

        $sequence_3 = { ff15???????? e9???????? 6a59 ff15???????? 85c0 7514 }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   e9????????           |                     
            //   6a59                 | push                0x59
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7514                 | jne                 0x16

        $sequence_4 = { ff15???????? 50 8b45fc 50 68???????? }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_5 = { 6a00 6a00 68???????? ff15???????? 6a02 }
            // n = 5, score = 400
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     
            //   6a02                 | push                2

        $sequence_6 = { 52 e8???????? 83c404 0fbec0 83e857 }
            // n = 5, score = 400
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   0fbec0               | movsx               eax, al
            //   83e857               | sub                 eax, 0x57

        $sequence_7 = { 6a06 8b15???????? 52 ff15???????? a3???????? c705????????00000000 6a01 }
            // n = 7, score = 400
            //   6a06                 | push                6
            //   8b15????????         |                     
            //   52                   | push                edx
            //   ff15????????         |                     
            //   a3????????           |                     
            //   c705????????00000000     |     
            //   6a01                 | push                1

        $sequence_8 = { 85c0 7414 68???????? 8b4d08 51 }
            // n = 5, score = 400
            //   85c0                 | test                eax, eax
            //   7414                 | je                  0x16
            //   68????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx

        $sequence_9 = { a3???????? 833d????????00 0f85bc000000 e8???????? a3???????? 6808020000 }
            // n = 6, score = 400
            //   a3????????           |                     
            //   833d????????00       |                     
            //   0f85bc000000         | jne                 0xc2
            //   e8????????           |                     
            //   a3????????           |                     
            //   6808020000           | push                0x208

    condition:
        7 of them and filesize < 98304
}