rule win_dharma_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dharma."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dharma"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4218 33c9 668908 8b5508 }
            // n = 4, score = 100
            //   8b4218               | mov                 eax, dword ptr [edx + 0x18]
            //   33c9                 | xor                 ecx, ecx
            //   668908               | mov                 word ptr [eax], cx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_1 = { 81e10000ff00 33d1 8b45f0 c1e808 25ff000000 8b0c85b8b34000 81e100ff0000 }
            // n = 7, score = 100
            //   81e10000ff00         | and                 ecx, 0xff0000
            //   33d1                 | xor                 edx, ecx
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   c1e808               | shr                 eax, 8
            //   25ff000000           | and                 eax, 0xff
            //   8b0c85b8b34000       | mov                 ecx, dword ptr [eax*4 + 0x40b3b8]
            //   81e100ff0000         | and                 ecx, 0xff00

        $sequence_2 = { 6a08 8b450c 8b4818 51 e8???????? 83c408 2500ff00ff }
            // n = 7, score = 100
            //   6a08                 | push                8
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4818               | mov                 ecx, dword ptr [eax + 0x18]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   2500ff00ff           | and                 eax, 0xff00ff00

        $sequence_3 = { 51 8b55fc 52 ff15???????? 8b4df8 89048db8864100 8b55f8 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   89048db8864100       | mov                 dword ptr [ecx*4 + 0x4186b8], eax
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_4 = { 33c0 6689044a 8b4d08 8b5104 83c201 8955ec 8b4508 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   6689044a             | mov                 word ptr [edx + ecx*2], ax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   83c201               | add                 edx, 1
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_5 = { 732e 8b4df8 8a11 8855ef 8b45f8 8b4df4 8a11 }
            // n = 7, score = 100
            //   732e                 | jae                 0x30
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   8855ef               | mov                 byte ptr [ebp - 0x11], dl
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8a11                 | mov                 dl, byte ptr [ecx]

        $sequence_6 = { e8???????? 83c410 894590 6a02 6880000000 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   894590               | mov                 dword ptr [ebp - 0x70], eax
            //   6a02                 | push                2
            //   6880000000           | push                0x80

        $sequence_7 = { 83780800 7405 e8???????? 8b4d0c 51 8b55fc 52 }
            // n = 7, score = 100
            //   83780800             | cmp                 dword ptr [eax + 8], 0
            //   7405                 | je                  7
            //   e8????????           |                     
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   51                   | push                ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   52                   | push                edx

        $sequence_8 = { 2b4224 8d4c0002 51 8b5508 8b4224 8b4d08 8b5118 }
            // n = 7, score = 100
            //   2b4224               | sub                 eax, dword ptr [edx + 0x24]
            //   8d4c0002             | lea                 ecx, [eax + eax + 2]
            //   51                   | push                ecx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b4224               | mov                 eax, dword ptr [edx + 0x24]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b5118               | mov                 edx, dword ptr [ecx + 0x18]

        $sequence_9 = { 52 8b4510 50 e8???????? 83c408 85c0 7409 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb

    condition:
        7 of them and filesize < 204800
}