rule win_dircrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dircrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dircrypt"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 6a01 6a10 ff15???????? 50 }
            // n = 5, score = 900
            //   e8????????           |                     
            //   6a01                 | push                1
            //   6a10                 | push                0x10
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_1 = { e8???????? e8???????? e8???????? 68???????? ff15???????? 833d????????00 751a }
            // n = 7, score = 900
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   833d????????00       |                     
            //   751a                 | jne                 0x1c

        $sequence_2 = { 51 6a00 6a00 8d45fc 50 68???????? 6802000080 }
            // n = 7, score = 900
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   68????????           |                     
            //   6802000080           | push                0x80000002

        $sequence_3 = { 51 ff15???????? 8945fc 8b450c 2b4508 }
            // n = 5, score = 900
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   2b4508               | sub                 eax, dword ptr [ebp + 8]

        $sequence_4 = { 833d????????00 7528 c705????????01000000 e8???????? e8???????? }
            // n = 5, score = 900
            //   833d????????00       |                     
            //   7528                 | jne                 0x2a
            //   c705????????01000000     |     
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_5 = { 68???????? e8???????? 05d2070000 50 }
            // n = 4, score = 900
            //   68????????           |                     
            //   e8????????           |                     
            //   05d2070000           | add                 eax, 0x7d2
            //   50                   | push                eax

        $sequence_6 = { 51 ff15???????? 8945fc 8b450c 2b4508 50 }
            // n = 6, score = 900
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   2b4508               | sub                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax

        $sequence_7 = { 833d????????00 751e c705????????01000000 e8???????? e8???????? e8???????? }
            // n = 6, score = 900
            //   833d????????00       |                     
            //   751e                 | jne                 0x20
            //   c705????????01000000     |     
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_8 = { e8???????? 68???????? e8???????? e8???????? 6a01 e8???????? }
            // n = 6, score = 900
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   6a01                 | push                1
            //   e8????????           |                     

        $sequence_9 = { 6a01 6a06 8d45dc 50 }
            // n = 4, score = 900
            //   6a01                 | push                1
            //   6a06                 | push                6
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 671744
}