rule win_disttrack_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.disttrack."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.disttrack"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 50 e8???????? 83c404 68???????? ff15???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | je                  0x97
            //   50                   | inc                 dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   83c404               | add                 eax, 0x30
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_1 = { 53 ff15???????? 5d 5b 8bc7 5f 5e }
            // n = 7, score = 200
            //   53                   | mov                 edx, dword ptr [eax + 4]
            //   ff15????????         |                     
            //   5d                   | mov                 eax, dword ptr [ecx - 0x18]
            //   5b                   | mov                 edx, dword ptr [eax + 4]
            //   8bc7                 | mov                 dword ptr [ebp - 0x1c], esi
            //   5f                   | xor                 eax, eax
            //   5e                   | cmp                 dword ptr [eax + 0x41f8d0], edi

        $sequence_2 = { ff15???????? 8d45dc 50 ff15???????? 8b4ddc }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   8d45dc               | mov                 eax, 0x55555556
            //   50                   | imul                ecx
            //   ff15????????         |                     
            //   8b4ddc               | push                ebx

        $sequence_3 = { 57 e8???????? 6a07 e8???????? 59 c3 6a10 }
            // n = 7, score = 200
            //   57                   | mov                 edx, ebp
            //   e8????????           |                     
            //   6a07                 | inc                 esp
            //   e8????????           |                     
            //   59                   | lea                 eax, [eax + eax]
            //   c3                   | dec                 eax
            //   6a10                 | imul                edx, edx, 0x58

        $sequence_4 = { 52 6a00 6a00 6848000700 }
            // n = 4, score = 200
            //   52                   | push                esi
            //   6a00                 | mov                 esi, dword ptr [ebp - 8]
            //   6a00                 | sub                 eax, ecx
            //   6848000700           | add                 eax, edx

        $sequence_5 = { 83c420 53 6800010000 53 53 56 }
            // n = 6, score = 100
            //   83c420               | ret                 
            //   53                   | push                0x10
            //   6800010000           | mov                 dword ptr [esp + 0x34], 0x41c300
            //   53                   | mov                 dword ptr [esp + 0x44], 0x41c308
            //   53                   | mov                 dword ptr [esp + 0x3a0], ebx
            //   56                   | or                  dword ptr [esp + 0x2c], 1

        $sequence_6 = { 89410c 854110 740d 53 }
            // n = 4, score = 100
            //   89410c               | mov                 ecx, dword ptr [ebp - 0x24]
            //   854110               | lea                 eax, [ebp - 0x24]
            //   740d                 | push                eax
            //   53                   | mov                 ecx, dword ptr [ebp - 0x24]

        $sequence_7 = { 83c701 83d300 85f6 758c 8b45e0 8b55e4 83c0ff }
            // n = 7, score = 100
            //   83c701               | sar                 ebx, 5
            //   83d300               | and                 esi, 0x1f
            //   85f6                 | lea                 ebx, [ebx*4 + 0x421740]
            //   758c                 | lea                 ecx, [esp + 0x28f0]
            //   8b45e0               | push                eax
            //   8b55e4               | push                0
            //   83c0ff               | push                ebx

        $sequence_8 = { e8???????? 488d1dae690100 488bcb e8???????? 488bcf 448bc0 4503c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d1dae690100       | inc                 edx
            //   488bcb               | mov                 al, byte ptr [edx + ebp]
            //   e8????????           |                     
            //   488bcf               | inc                 ecx
            //   448bc0               | xor                 al, byte ptr [ecx]
            //   4503c0               | dec                 ecx

        $sequence_9 = { 488bd3 33c9 e8???????? 488bd8 488d0584210100 }
            // n = 5, score = 100
            //   488bd3               | mov                 ebx, eax
            //   33c9                 | mov                 ecx, eax
            //   e8????????           |                     
            //   488bd8               | mov                 eax, edx
            //   488d0584210100       | inc                 ecx

        $sequence_10 = { 498bcd e8???????? 4a8d4c5d80 498bd5 448d0400 e8???????? }
            // n = 6, score = 100
            //   498bcd               | dec                 eax
            //   e8????????           |                     
            //   4a8d4c5d80           | xor                 ecx, esp
            //   498bd5               | dec                 esp
            //   448d0400             | lea                 ebx, [esp + 0x480]
            //   e8????????           |                     

        $sequence_11 = { 32db ff15???????? c78520ffffff202b4200 c78530ffffff702a4200 c74590cc294200 }
            // n = 5, score = 100
            //   32db                 | pop                 ebp
            //   ff15????????         |                     
            //   c78520ffffff202b4200     | pop    ebx
            //   c78530ffffff702a4200     | mov    eax, edi
            //   c74590cc294200       | pop                 edi

        $sequence_12 = { 4c2bc6 33d2 8bc3 ffc3 f7b42498000000 428a042a 413201 }
            // n = 7, score = 100
            //   4c2bc6               | dec                 eax
            //   33d2                 | mov                 ebx, eax
            //   8bc3                 | dec                 eax
            //   ffc3                 | lea                 eax, [0x12184]
            //   f7b42498000000       | xor                 al, al
            //   428a042a             | dec                 eax
            //   413201               | mov                 ecx, dword ptr [ebp + 0x370]

        $sequence_13 = { 75fc 8b0d???????? 51 e8???????? 83c404 833d????????00 }
            // n = 6, score = 100
            //   75fc                 | push                0x10
            //   8b0d????????         |                     
            //   51                   | push                edi
            //   e8????????           |                     
            //   83c404               | push                7
            //   833d????????00       |                     

        $sequence_14 = { ff15???????? 32c0 488b8d70030000 4833cc e8???????? 4c8d9c2480040000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   32c0                 | sub                 eax, ebx
            //   488b8d70030000       | dec                 eax
            //   4833cc               | mov                 edx, ebx
            //   e8????????           |                     
            //   4c8d9c2480040000     | xor                 ecx, ecx

        $sequence_15 = { 02c0 02d0 8a45fa 88550c 8ad0 c0ea02 }
            // n = 6, score = 100
            //   02c0                 | dec                 eax
            //   02d0                 | mov                 ecx, edi
            //   8a45fa               | inc                 esp
            //   88550c               | mov                 eax, eax
            //   8ad0                 | inc                 ebp
            //   c0ea02               | add                 eax, eax

        $sequence_16 = { 8b75f8 2bc1 03c2 c1fb05 83e61f 8d1c9d40174200 }
            // n = 6, score = 100
            //   8b75f8               | push                4
            //   2bc1                 | add                 al, al
            //   03c2                 | add                 dl, al
            //   c1fb05               | mov                 al, byte ptr [ebp - 6]
            //   83e61f               | mov                 byte ptr [ebp + 0xc], dl
            //   8d1c9d40174200       | mov                 dl, al

        $sequence_17 = { 8975e4 33c0 39b8d0f84100 0f8491000000 ff45e4 83c030 }
            // n = 6, score = 100
            //   8975e4               | dec                 eax
            //   33c0                 | mov                 edx, ebx
            //   39b8d0f84100         | push                edi
            //   0f8491000000         | push                7
            //   ff45e4               | pop                 ecx
            //   83c030               | ret                 

        $sequence_18 = { c7440ae8b4c24100 8b41f8 8b5004 c7440af8???????? 8b41e8 8b5004 }
            // n = 6, score = 100
            //   c7440ae8b4c24100     | dec                 ebp
            //   8b41f8               | add                 eax, eax
            //   8b5004               | mov                 edx, eax
            //   c7440af8????????     |                     
            //   8b41e8               | dec                 eax
            //   8b5004               | lea                 ecx, [esp + edx*2 + 0x40]

        $sequence_19 = { 0fb755d4 0fb745e4 3bd0 750c 0fb74dd6 0fb755e6 }
            // n = 6, score = 100
            //   0fb755d4             | mov                 eax, edi
            //   0fb745e4             | pop                 edi
            //   3bd0                 | pop                 esi
            //   750c                 | add                 esp, 4
            //   0fb74dd6             | push                eax
            //   0fb755e6             | add                 esp, 4

        $sequence_20 = { 64a300000000 8965e8 837d0800 741f 837d1c00 7419 }
            // n = 6, score = 100
            //   64a300000000         | pop                 ecx
            //   8965e8               | ret                 
            //   837d0800             | push                0x10
            //   741f                 | push                ebx
            //   837d1c00             | pop                 ebp
            //   7419                 | pop                 ebx

        $sequence_21 = { c744243400c34100 c744244408c34100 899c24a0030000 834c242c01 6a04 }
            // n = 5, score = 100
            //   c744243400c34100     | mov                 edx, ecx
            //   c744244408c34100     | dec                 eax
            //   899c24a0030000       | lea                 ebx, [0x169ae]
            //   834c242c01           | dec                 eax
            //   6a04                 | mov                 ecx, ebx

        $sequence_22 = { 4883ec28 ff15???????? 8b15???????? 448bd8 8bc8 8bc2 412bc3 }
            // n = 7, score = 100
            //   4883ec28             | dec                 eax
            //   ff15????????         |                     
            //   8b15????????         |                     
            //   448bd8               | mov                 eax, dword ptr [ebp - 0x50]
            //   8bc8                 | dec                 eax
            //   8bc2                 | sub                 esp, 0x28
            //   412bc3               | inc                 esp

        $sequence_23 = { 486bd258 490314c8 488d0d1f9b0100 eb11 488d0d169b0100 488bd1 }
            // n = 6, score = 100
            //   486bd258             | dec                 esp
            //   490314c8             | sub                 eax, esi
            //   488d0d1f9b0100       | xor                 edx, edx
            //   eb11                 | mov                 eax, ebx
            //   488d0d169b0100       | inc                 ebx
            //   488bd1               | div                 dword ptr [esp + 0x98]

        $sequence_24 = { b856555555 f7e9 53 8bc2 56 c1e81f 8d540204 }
            // n = 7, score = 100
            //   b856555555           | push                0x10
            //   f7e9                 | push                7
            //   53                   | pop                 ecx
            //   8bc2                 | ret                 
            //   56                   | push                0x10
            //   c1e81f               | push                7
            //   8d540204             | pop                 ecx

        $sequence_25 = { c6400d10 488b45b0 83600800 488b45b0 }
            // n = 4, score = 100
            //   c6400d10             | mov                 byte ptr [eax + 0xd], 0x10
            //   488b45b0             | dec                 eax
            //   83600800             | mov                 eax, dword ptr [ebp - 0x50]
            //   488b45b0             | and                 dword ptr [eax + 8], 0

        $sequence_26 = { c744243c702a4200 c784249c0000007c2a4200 8d542444 52 8d442430 89bc245c060000 }
            // n = 6, score = 100
            //   c744243c702a4200     | pop                 esi
            //   c784249c0000007c2a4200     | add    esp, 4
            //   8d542444             | push                eax
            //   52                   | add                 esp, 4
            //   8d442430             | lea                 eax, [ebp - 0x24]
            //   89bc245c060000       | push                eax

    condition:
        7 of them and filesize < 1112064
}