rule win_divergent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.divergent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.divergent"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85ff 0f8400010000 53 56 8b7508 57 }
            // n = 6, score = 300
            //   85ff                 | test                edi, edi
            //   0f8400010000         | je                  0x106
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi

        $sequence_1 = { 50 e8???????? 83c40c 8d45f8 6a02 6a08 50 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   6a02                 | push                2
            //   6a08                 | push                8
            //   50                   | push                eax

        $sequence_2 = { 3b4510 7518 ff7510 8b4704 ff750c }
            // n = 5, score = 300
            //   3b4510               | cmp                 eax, dword ptr [ebp + 0x10]
            //   7518                 | jne                 0x1a
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_3 = { e9???????? 57 bf???????? 57 ff15???????? 85c0 7474 }
            // n = 7, score = 300
            //   e9????????           |                     
            //   57                   | push                edi
            //   bf????????           |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7474                 | je                  0x76

        $sequence_4 = { 0f888cfeffff 85f6 7402 03f0 03f8 33c9 }
            // n = 6, score = 300
            //   0f888cfeffff         | js                  0xfffffe92
            //   85f6                 | test                esi, esi
            //   7402                 | je                  4
            //   03f0                 | add                 esi, eax
            //   03f8                 | add                 edi, eax
            //   33c9                 | xor                 ecx, ecx

        $sequence_5 = { 742c 8b463c ff743054 56 57 }
            // n = 5, score = 300
            //   742c                 | je                  0x2e
            //   8b463c               | mov                 eax, dword ptr [esi + 0x3c]
            //   ff743054             | push                dword ptr [eax + esi + 0x54]
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_6 = { 8955fc 2500000080 df6df8 8365f800 8945fc }
            // n = 5, score = 300
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   2500000080           | and                 eax, 0x80000000
            //   df6df8               | fild                qword ptr [ebp - 8]
            //   8365f800             | and                 dword ptr [ebp - 8], 0
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_7 = { 84c0 7512 8b45fc 40 817d0c1a000080 }
            // n = 5, score = 300
            //   84c0                 | test                al, al
            //   7512                 | jne                 0x14
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   40                   | inc                 eax
            //   817d0c1a000080       | cmp                 dword ptr [ebp + 0xc], 0x8000001a

        $sequence_8 = { 8b4608 8b0488 eb02 33c0 5e 5d }
            // n = 6, score = 300
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8b0488               | mov                 eax, dword ptr [eax + ecx*4]
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_9 = { 833fff 7437 8d4628 50 ff37 e8???????? 59 }
            // n = 7, score = 300
            //   833fff               | cmp                 dword ptr [edi], -1
            //   7437                 | je                  0x39
            //   8d4628               | lea                 eax, [esi + 0x28]
            //   50                   | push                eax
            //   ff37                 | push                dword ptr [edi]
            //   e8????????           |                     
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 212992
}