rule win_donex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.donex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.donex"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 03c2 8b55f4 c1c008 03c2 8945ec 8b45fc 8bc8 }
            // n = 7, score = 100
            //   03c2                 | add                 eax, edx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   c1c008               | rol                 eax, 8
            //   03c2                 | add                 eax, edx
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8bc8                 | mov                 ecx, eax

        $sequence_1 = { 2345f8 0375cc 0bc8 034dc4 03f7 8b45f4 8b7de8 }
            // n = 7, score = 100
            //   2345f8               | and                 eax, dword ptr [ebp - 8]
            //   0375cc               | add                 esi, dword ptr [ebp - 0x34]
            //   0bc8                 | or                  ecx, eax
            //   034dc4               | add                 ecx, dword ptr [ebp - 0x3c]
            //   03f7                 | add                 esi, edi
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b7de8               | mov                 edi, dword ptr [ebp - 0x18]

        $sequence_2 = { e8???????? 8b404c 83b8a800000000 7512 8b04bd08a44300 807c302900 7504 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b404c               | mov                 eax, dword ptr [eax + 0x4c]
            //   83b8a800000000       | cmp                 dword ptr [eax + 0xa8], 0
            //   7512                 | jne                 0x14
            //   8b04bd08a44300       | mov                 eax, dword ptr [edi*4 + 0x43a408]
            //   807c302900           | cmp                 byte ptr [eax + esi + 0x29], 0
            //   7504                 | jne                 6

        $sequence_3 = { 40 50 8d8598fcffff 50 e8???????? eb09 ff750c }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   8d8598fcffff         | lea                 eax, [ebp - 0x368]
            //   50                   | push                eax
            //   e8????????           |                     
            //   eb09                 | jmp                 0xb
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_4 = { 2345ec 0bc1 c145f40a 034598 8b4dd8 03c2 }
            // n = 6, score = 100
            //   2345ec               | and                 eax, dword ptr [ebp - 0x14]
            //   0bc1                 | or                  eax, ecx
            //   c145f40a             | rol                 dword ptr [ebp - 0xc], 0xa
            //   034598               | add                 eax, dword ptr [ebp - 0x68]
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   03c2                 | add                 eax, edx

        $sequence_5 = { c1c00e 8bce 03c2 f7d1 234dec 81c2e9766d7a }
            // n = 6, score = 100
            //   c1c00e               | rol                 eax, 0xe
            //   8bce                 | mov                 ecx, esi
            //   03c2                 | add                 eax, edx
            //   f7d1                 | not                 ecx
            //   234dec               | and                 ecx, dword ptr [ebp - 0x14]
            //   81c2e9766d7a         | add                 edx, 0x7a6d76e9

        $sequence_6 = { 897df0 3b7dfc 0f826cffffff ff75e8 ff15???????? ff75ec e8???????? }
            // n = 7, score = 100
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   3b7dfc               | cmp                 edi, dword ptr [ebp - 4]
            //   0f826cffffff         | jb                  0xffffff72
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   ff15????????         |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     

        $sequence_7 = { 8bca c1c906 33f9 8b4df4 33cb 23ca 334df4 }
            // n = 7, score = 100
            //   8bca                 | mov                 ecx, edx
            //   c1c906               | ror                 ecx, 6
            //   33f9                 | xor                 edi, ecx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   33cb                 | xor                 ecx, ebx
            //   23ca                 | and                 ecx, edx
            //   334df4               | xor                 ecx, dword ptr [ebp - 0xc]

        $sequence_8 = { 56 57 56 c706ffffffff e8???????? 83c40c 8945fc }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   56                   | push                esi
            //   c706ffffffff         | mov                 dword ptr [esi], 0xffffffff
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_9 = { 83c408 85db 7529 57 ff7508 e8???????? 8bd8 }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   85db                 | test                ebx, ebx
            //   7529                 | jne                 0x2b
            //   57                   | push                edi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

    condition:
        7 of them and filesize < 505856
}