rule win_doplugs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.doplugs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doplugs"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ebc7 c60000 40 b988e80fa2 ba0977e673 3b45d8 0f44ca }
            // n = 7, score = 200
            //   ebc7                 | jmp                 0xffffffc9
            //   c60000               | mov                 byte ptr [eax], 0
            //   40                   | inc                 eax
            //   b988e80fa2           | mov                 ecx, 0xa20fe888
            //   ba0977e673           | mov                 edx, 0x73e67709
            //   3b45d8               | cmp                 eax, dword ptr [ebp - 0x28]
            //   0f44ca               | cmove               ecx, edx

        $sequence_1 = { ba7c5c3f74 ebd4 8a44240b be420360ff 884203 c7042469000000 81fe7c5c3f74 }
            // n = 7, score = 200
            //   ba7c5c3f74           | mov                 edx, 0x743f5c7c
            //   ebd4                 | jmp                 0xffffffd6
            //   8a44240b             | mov                 al, byte ptr [esp + 0xb]
            //   be420360ff           | mov                 esi, 0xff600342
            //   884203               | mov                 byte ptr [edx + 3], al
            //   c7042469000000       | mov                 dword ptr [esp], 0x69
            //   81fe7c5c3f74         | cmp                 esi, 0x743f5c7c

        $sequence_2 = { ebb4 3d3c391092 0f84c4000000 3d3c69c7d0 75a2 8b45c8 8b45c8 }
            // n = 7, score = 200
            //   ebb4                 | jmp                 0xffffffb6
            //   3d3c391092           | cmp                 eax, 0x9210393c
            //   0f84c4000000         | je                  0xca
            //   3d3c69c7d0           | cmp                 eax, 0xd0c7693c
            //   75a2                 | jne                 0xffffffa4
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]

        $sequence_3 = { f6d0 248d 08c2 8b442408 88d6 80f24c 80f6b3 }
            // n = 7, score = 200
            //   f6d0                 | not                 al
            //   248d                 | and                 al, 0x8d
            //   08c2                 | or                  dl, al
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   88d6                 | mov                 dh, dl
            //   80f24c               | xor                 dl, 0x4c
            //   80f6b3               | xor                 dh, 0xb3

        $sequence_4 = { e9???????? 8b4de4 e8???????? 8b4dbc 83c130 6a20 51 }
            // n = 7, score = 200
            //   e9????????           |                     
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   8b4dbc               | mov                 ecx, dword ptr [ebp - 0x44]
            //   83c130               | add                 ecx, 0x30
            //   6a20                 | push                0x20
            //   51                   | push                ecx

        $sequence_5 = { e9???????? 31c0 b9c9efbb33 81f94e706309 7e21 81f92b388626 7f4e }
            // n = 7, score = 200
            //   e9????????           |                     
            //   31c0                 | xor                 eax, eax
            //   b9c9efbb33           | mov                 ecx, 0x33bbefc9
            //   81f94e706309         | cmp                 ecx, 0x963704e
            //   7e21                 | jle                 0x23
            //   81f92b388626         | cmp                 ecx, 0x2686382b
            //   7f4e                 | jg                  0x50

        $sequence_6 = { c74424044363617e c744240869436b67 66c744240c6c7b 896c242c c644240e73 890424 8d44240f }
            // n = 7, score = 200
            //   c74424044363617e     | mov                 dword ptr [esp + 4], 0x7e616343
            //   c744240869436b67     | mov                 dword ptr [esp + 8], 0x676b4369
            //   66c744240c6c7b       | mov                 word ptr [esp + 0xc], 0x7b6c
            //   896c242c             | mov                 dword ptr [esp + 0x2c], ebp
            //   c644240e73           | mov                 byte ptr [esp + 0xe], 0x73
            //   890424               | mov                 dword ptr [esp], eax
            //   8d44240f             | lea                 eax, [esp + 0xf]

        $sequence_7 = { f7d3 21cb 09de bb351d2051 31fe 6689742414 ebbd }
            // n = 7, score = 200
            //   f7d3                 | not                 ebx
            //   21cb                 | and                 ebx, ecx
            //   09de                 | or                  esi, ebx
            //   bb351d2051           | mov                 ebx, 0x51201d35
            //   31fe                 | xor                 esi, edi
            //   6689742414           | mov                 word ptr [esp + 0x14], si
            //   ebbd                 | jmp                 0xffffffbf

        $sequence_8 = { b927018432 e9???????? 8b0c24 01e9 894c2410 8b4c2410 8a09 }
            // n = 7, score = 200
            //   b927018432           | mov                 ecx, 0x32840127
            //   e9????????           |                     
            //   8b0c24               | mov                 ecx, dword ptr [esp]
            //   01e9                 | add                 ecx, ebp
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   8a09                 | mov                 cl, byte ptr [ecx]

        $sequence_9 = { f7d2 21da 09d0 8b542414 31c8 668902 8b0424 }
            // n = 7, score = 200
            //   f7d2                 | not                 edx
            //   21da                 | and                 edx, ebx
            //   09d0                 | or                  eax, edx
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   31c8                 | xor                 eax, ecx
            //   668902               | mov                 word ptr [edx], ax
            //   8b0424               | mov                 eax, dword ptr [esp]

    condition:
        7 of them and filesize < 1355776
}