rule win_doublefantasy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.doublefantasy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doublefantasy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d50fd 891485a4ab2700 40 3bc1 72f1 833d????????fd 7516 }
            // n = 7, score = 200
            //   8d50fd               | lea                 edx, [eax - 3]
            //   891485a4ab2700       | mov                 dword ptr [eax*4 + 0x27aba4], edx
            //   40                   | inc                 eax
            //   3bc1                 | cmp                 eax, ecx
            //   72f1                 | jb                  0xfffffff3
            //   833d????????fd       |                     
            //   7516                 | jne                 0x18

        $sequence_1 = { 50 8d45d4 50 ff7508 ff15???????? 83c41c }
            // n = 6, score = 200
            //   50                   | push                eax
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   83c41c               | add                 esp, 0x1c

        $sequence_2 = { 57 53 68???????? ff75d8 8b35???????? ffd6 8945e0 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   53                   | push                ebx
            //   68????????           |                     
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax

        $sequence_3 = { 33d2 8a5001 c1ee06 83e20f c1e202 0bd6 8a92908c2700 }
            // n = 7, score = 200
            //   33d2                 | xor                 edx, edx
            //   8a5001               | mov                 dl, byte ptr [eax + 1]
            //   c1ee06               | shr                 esi, 6
            //   83e20f               | and                 edx, 0xf
            //   c1e202               | shl                 edx, 2
            //   0bd6                 | or                  edx, esi
            //   8a92908c2700         | mov                 dl, byte ptr [edx + 0x278c90]

        $sequence_4 = { 40 c3 33c9 3b05???????? 0f9cc1 8bc1 c3 }
            // n = 7, score = 200
            //   40                   | inc                 eax
            //   c3                   | ret                 
            //   33c9                 | xor                 ecx, ecx
            //   3b05????????         |                     
            //   0f9cc1               | setl                cl
            //   8bc1                 | mov                 eax, ecx
            //   c3                   | ret                 

        $sequence_5 = { 50 ff15???????? 897e10 897e0c 8b7620 3bf7 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   897e10               | mov                 dword ptr [esi + 0x10], edi
            //   897e0c               | mov                 dword ptr [esi + 0xc], edi
            //   8b7620               | mov                 esi, dword ptr [esi + 0x20]
            //   3bf7                 | cmp                 esi, edi

        $sequence_6 = { 8b442404 0fb608 c1e902 8a91908c2700 8b4c2408 }
            // n = 5, score = 200
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   0fb608               | movzx               ecx, byte ptr [eax]
            //   c1e902               | shr                 ecx, 2
            //   8a91908c2700         | mov                 dl, byte ptr [ecx + 0x278c90]
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]

        $sequence_7 = { 0bd6 8a92908c2700 eb02 b23d 837c241002 }
            // n = 5, score = 200
            //   0bd6                 | or                  edx, esi
            //   8a92908c2700         | mov                 dl, byte ptr [edx + 0x278c90]
            //   eb02                 | jmp                 4
            //   b23d                 | mov                 dl, 0x3d
            //   837c241002           | cmp                 dword ptr [esp + 0x10], 2

        $sequence_8 = { 3c7a 770b 0fb6c0 8a80ad8c2700 eb02 }
            // n = 5, score = 200
            //   3c7a                 | cmp                 al, 0x7a
            //   770b                 | ja                  0xd
            //   0fb6c0               | movzx               eax, al
            //   8a80ad8c2700         | mov                 al, byte ptr [eax + 0x278cad]
            //   eb02                 | jmp                 4

        $sequence_9 = { 68???????? e8???????? 8b4605 c68094a3270000 ff35???????? ff35???????? }
            // n = 6, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   8b4605               | mov                 eax, dword ptr [esi + 5]
            //   c68094a3270000       | mov                 byte ptr [eax + 0x27a394], 0
            //   ff35????????         |                     
            //   ff35????????         |                     

        $sequence_10 = { ff35???????? e8???????? 83c41c e8???????? 33ff e9???????? }
            // n = 6, score = 200
            //   ff35????????         |                     
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   e8????????           |                     
            //   33ff                 | xor                 edi, edi
            //   e9????????           |                     

        $sequence_11 = { 85c9 7616 8da42400000000 8d50fd 891485a4ab2700 40 }
            // n = 6, score = 200
            //   85c9                 | test                ecx, ecx
            //   7616                 | jbe                 0x18
            //   8da42400000000       | lea                 esp, [esp]
            //   8d50fd               | lea                 edx, [eax - 3]
            //   891485a4ab2700       | mov                 dword ptr [eax*4 + 0x27aba4], edx
            //   40                   | inc                 eax

        $sequence_12 = { c745e405400080 8365fc00 c745fc01000000 8b7508 8b4620 85c0 7477 }
            // n = 7, score = 200
            //   c745e405400080       | mov                 dword ptr [ebp - 0x1c], 0x80004005
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   85c0                 | test                eax, eax
            //   7477                 | je                  0x79

        $sequence_13 = { 8a92908c2700 885101 7e1c 0fb67002 33d2 8a5001 }
            // n = 6, score = 200
            //   8a92908c2700         | mov                 dl, byte ptr [edx + 0x278c90]
            //   885101               | mov                 byte ptr [ecx + 1], dl
            //   7e1c                 | jle                 0x1e
            //   0fb67002             | movzx               esi, byte ptr [eax + 2]
            //   33d2                 | xor                 edx, edx
            //   8a5001               | mov                 dl, byte ptr [eax + 1]

        $sequence_14 = { e8???????? 50 6a5c 57 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   50                   | push                eax
            //   6a5c                 | push                0x5c
            //   57                   | push                edi

        $sequence_15 = { 837df804 59 7426 6800002000 }
            // n = 4, score = 200
            //   837df804             | cmp                 dword ptr [ebp - 8], 4
            //   59                   | pop                 ecx
            //   7426                 | je                  0x28
            //   6800002000           | push                0x200000

    condition:
        7 of them and filesize < 172032
}