rule win_downdelph_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.downdelph."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.downdelph"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45fc e8???????? 8b55dc b8???????? }
            // n = 4, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b55dc               | mov                 edx, dword ptr [ebp - 0x24]
            //   b8????????           |                     

        $sequence_1 = { 42 8b45fc 8b04b8 59 }
            // n = 4, score = 100
            //   42                   | inc                 edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b04b8               | mov                 eax, dword ptr [eax + edi*4]
            //   59                   | pop                 ecx

        $sequence_2 = { 8955f8 8945fc 8b45fc e8???????? 8b45f8 e8???????? 8d75bc }
            // n = 7, score = 100
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   e8????????           |                     
            //   8d75bc               | lea                 esi, [ebp - 0x44]

        $sequence_3 = { 8d45cc ba08000000 e8???????? 8d45f4 }
            // n = 4, score = 100
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   ba08000000           | mov                 edx, 8
            //   e8????????           |                     
            //   8d45f4               | lea                 eax, [ebp - 0xc]

        $sequence_4 = { 0345e8 33c9 e8???????? 837df401 7e7f 83450804 ff4df4 }
            // n = 7, score = 100
            //   0345e8               | add                 eax, dword ptr [ebp - 0x18]
            //   33c9                 | xor                 ecx, ecx
            //   e8????????           |                     
            //   837df401             | cmp                 dword ptr [ebp - 0xc], 1
            //   7e7f                 | jle                 0x81
            //   83450804             | add                 dword ptr [ebp + 8], 4
            //   ff4df4               | dec                 dword ptr [ebp - 0xc]

        $sequence_5 = { ff35???????? 68???????? 8d45e8 ba03000000 }
            // n = 4, score = 100
            //   ff35????????         |                     
            //   68????????           |                     
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   ba03000000           | mov                 edx, 3

        $sequence_6 = { e8???????? 8945fc 837dfc00 0f8484000000 837dfc01 754b }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   0f8484000000         | je                  0x8a
            //   837dfc01             | cmp                 dword ptr [ebp - 4], 1
            //   754b                 | jne                 0x4d

        $sequence_7 = { 33c0 89461c 33c0 894620 33c0 894624 33c0 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   89461c               | mov                 dword ptr [esi + 0x1c], eax
            //   33c0                 | xor                 eax, eax
            //   894620               | mov                 dword ptr [esi + 0x20], eax
            //   33c0                 | xor                 eax, eax
            //   894624               | mov                 dword ptr [esi + 0x24], eax
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 4f 75cd 33c0 5a 59 }
            // n = 5, score = 100
            //   4f                   | dec                 edi
            //   75cd                 | jne                 0xffffffcf
            //   33c0                 | xor                 eax, eax
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx

        $sequence_9 = { ba???????? e8???????? 0f8408030000 8d55e0 }
            // n = 4, score = 100
            //   ba????????           |                     
            //   e8????????           |                     
            //   0f8408030000         | je                  0x30e
            //   8d55e0               | lea                 edx, [ebp - 0x20]

    condition:
        7 of them and filesize < 172032
}