rule win_dratzarus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dratzarus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dratzarus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66c744243876d4 c785e0000000eb6cf5c3 c785e4000000994fa64a c785e8000000961a40af 66c785ec00000072ff c685ee000000e4 }
            // n = 6, score = 200
            //   66c744243876d4       | movzx               eax, byte ptr [edi + ecx]
            //   c785e0000000eb6cf5c3     | dec    ebx
            //   c785e4000000994fa64a     | inc    edx
            //   c785e8000000961a40af     | mov    byte ptr [ecx], al
            //   66c785ec00000072ff     | jmp    0x925
            //   c685ee000000e4       | mov                 byte ptr [ecx], 0

        $sequence_1 = { 48895c2408 55 488d6c24a9 4881ec90000000 488d4de7 ba0d000000 c745e72af5766c }
            // n = 7, score = 200
            //   48895c2408           | inc                 ebp
            //   55                   | movzx               eax, bx
            //   488d6c24a9           | dec                 eax
            //   4881ec90000000       | mov                 edx, edi
            //   488d4de7             | dec                 ecx
            //   ba0d000000           | dec                 eax
            //   c745e72af5766c       | jne                 0x705

        $sequence_2 = { c745cc178fe463 66c745d07449 e8???????? 488bc8 ff15???????? }
            // n = 5, score = 200
            //   c745cc178fe463       | lea                 edx, [0x17608]
            //   66c745d07449         | dec                 eax
            //   e8????????           |                     
            //   488bc8               | lea                 ecx, [ebp + 0x150]
            //   ff15????????         |                     

        $sequence_3 = { c644243660 c74424284071b330 66c744242c2f3e c644242e60 c74424407a767776 c74424447e767529 c74424205277bc30 }
            // n = 7, score = 200
            //   c644243660           | dec                 ebp
            //   c74424284071b330     | cmp                 eax, 1
            //   66c744242c2f3e       | jle                 0x237
            //   c644242e60           | dec                 eax
            //   c74424407a767776     | lea                 edx, [0x53b4f]
            //   c74424447e767529     | inc                 ecx
            //   c74424205277bc30     | mov                 eax, 0x93

        $sequence_4 = { 488d8d88020000 ba13000000 488905???????? e8???????? }
            // n = 4, score = 200
            //   488d8d88020000       | dec                 eax
            //   ba13000000           | mov                 ecx, edi
            //   488905????????       |                     
            //   e8????????           |                     

        $sequence_5 = { 89742450 6689b510020000 48898512020000 4889851a020000 66898522020000 6689b500030000 e8???????? }
            // n = 7, score = 200
            //   89742450             | inc                 ecx
            //   6689b510020000       | mov                 ecx, 0x2691
            //   48898512020000       | dec                 eax
            //   4889851a020000       | lea                 ebx, [0x5047a]
            //   66898522020000       | dec                 esp
            //   6689b500030000       | lea                 ecx, [ebp + 0x270]
            //   e8????????           |                     

        $sequence_6 = { 4533db 458d4310 488d942430010000 488d4c2420 }
            // n = 4, score = 200
            //   4533db               | lea                 ecx, [ebp + 0x1d61]
            //   458d4310             | inc                 ecx
            //   488d942430010000     | mov                 eax, 0x1000
            //   488d4c2420           | mov                 word ptr [ebp + 0x720], si

        $sequence_7 = { 666666666666660f1f840000000000 0fb7040a 4883c102 6689440ffc 6685c0 75ee 488d8c2480020000 }
            // n = 7, score = 200
            //   666666666666660f1f840000000000     | inc    esp
            //   0fb7040a             | lea                 eax, [edx + 6]
            //   4883c102             | mov                 dword ptr [esp + 0x20], 0x23a
            //   6689440ffc           | dec                 eax
            //   6685c0               | lea                 edx, [0x343ce]
            //   75ee                 | dec                 esp
            //   488d8c2480020000     | mov                 eax, edi

        $sequence_8 = { c745e85b02d12d c745ecde00c41e c745f0b2db7461 c645f478 e8???????? 488bc8 ff15???????? }
            // n = 7, score = 200
            //   c745e85b02d12d       | test                edx, edx
            //   c745ecde00c41e       | je                  0x9e
            //   c745f0b2db7461       | cmp                 esi, 4
            //   c645f478             | jne                 0x1d7
            //   e8????????           |                     
            //   488bc8               | dec                 ebp
            //   ff15????????         |                     

        $sequence_9 = { 488b05???????? 4889470e 8b05???????? 894716 33c0 }
            // n = 5, score = 200
            //   488b05????????       |                     
            //   4889470e             | lea                 eax, [ebp + 0x150]
            //   8b05????????         |                     
            //   894716               | dec                 eax
            //   33c0                 | lea                 edx, [0x17643]

    condition:
        7 of them and filesize < 1606656
}