rule win_dreambot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dreambot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dreambot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff35???????? ffd6 897b20 6a00 }
            // n = 4, score = 700
            //   ff35????????         |                     
            //   ffd6                 | call                esi
            //   897b20               | mov                 dword ptr [ebx + 0x20], edi
            //   6a00                 | push                0

        $sequence_1 = { ffd6 8b44240c 894320 68???????? ff7320 }
            // n = 5, score = 700
            //   ffd6                 | call                esi
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   894320               | mov                 dword ptr [ebx + 0x20], eax
            //   68????????           |                     
            //   ff7320               | push                dword ptr [ebx + 0x20]

        $sequence_2 = { 50 ff7320 56 ff5710 8b16 }
            // n = 5, score = 700
            //   50                   | push                eax
            //   ff7320               | push                dword ptr [ebx + 0x20]
            //   56                   | push                esi
            //   ff5710               | call                dword ptr [edi + 0x10]
            //   8b16                 | mov                 edx, dword ptr [esi]

        $sequence_3 = { e8???????? 8b7d0c eb02 33c0 8b4f30 83e140 0b4b18 }
            // n = 7, score = 700
            //   e8????????           |                     
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   8b4f30               | mov                 ecx, dword ptr [edi + 0x30]
            //   83e140               | and                 ecx, 0x40
            //   0b4b18               | or                  ecx, dword ptr [ebx + 0x18]

        $sequence_4 = { c7473000000000 e9???????? 834f3001 8b4720 }
            // n = 4, score = 700
            //   c7473000000000       | mov                 dword ptr [edi + 0x30], 0
            //   e9????????           |                     
            //   834f3001             | or                  dword ptr [edi + 0x30], 1
            //   8b4720               | mov                 eax, dword ptr [edi + 0x20]

        $sequence_5 = { 8b471c 8b08 81f948545450 740c 81f9504f5354 }
            // n = 5, score = 700
            //   8b471c               | mov                 eax, dword ptr [edi + 0x1c]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   81f948545450         | cmp                 ecx, 0x50545448
            //   740c                 | je                  0xe
            //   81f9504f5354         | cmp                 ecx, 0x54534f50

        $sequence_6 = { 8b4734 e8???????? 85c0 751a }
            // n = 4, score = 700
            //   8b4734               | mov                 eax, dword ptr [edi + 0x34]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   751a                 | jne                 0x1c

        $sequence_7 = { 7475 8b4618 e8???????? 8bf8 85ff 7547 }
            // n = 6, score = 700
            //   7475                 | je                  0x77
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7547                 | jne                 0x49

        $sequence_8 = { 3bf3 7474 395d0c 746f }
            // n = 4, score = 600
            //   3bf3                 | inc                 ecx
            //   7474                 | cmp                 esi, ebp
            //   395d0c               | je                  0x61
            //   746f                 | mov                 edx, esi

        $sequence_9 = { 53 68???????? eb54 3bf3 745c }
            // n = 5, score = 600
            //   53                   | dec                 ecx
            //   68????????           |                     
            //   eb54                 | cmp                 edi, ebp
            //   3bf3                 | je                  0xe2
            //   745c                 | inc                 ecx

        $sequence_10 = { 0f84b7000000 395d0c 0f84ae000000 6a01 ff750c 56 }
            // n = 6, score = 600
            //   0f84b7000000         | cmp                 eax, ebp
            //   395d0c               | je                  0x4b
            //   0f84ae000000         | jne                 0x2a
            //   6a01                 | dec                 ecx
            //   ff750c               | cmp                 edi, ebp
            //   56                   | je                  0x28

        $sequence_11 = { 3bf3 0f8481000000 395d0c 747c 6a03 }
            // n = 5, score = 600
            //   3bf3                 | test                eax, eax
            //   0f8481000000         | jne                 0x22
            //   395d0c               | cmp                 esi, ebx
            //   747c                 | je                  0x22
            //   6a03                 | je                  0xbd

        $sequence_12 = { 68???????? e8???????? 894508 8b7d08 eb24 }
            // n = 5, score = 600
            //   68????????           |                     
            //   e8????????           |                     
            //   894508               | push                3
            //   8b7d08               | cmp                 dword ptr [ebp + 0xc], 4
            //   eb24                 | jne                 0x18

        $sequence_13 = { 85c0 7520 3bf3 741c }
            // n = 4, score = 600
            //   85c0                 | cmp                 esi, ebp
            //   7520                 | je                  0xe2
            //   3bf3                 | mov                 ebx, 0x57
            //   741c                 | inc                 ecx

        $sequence_14 = { 837d0c04 7516 ff7510 ff36 68???????? }
            // n = 5, score = 600
            //   837d0c04             | cmp                 dword ptr [ebp + 0xc], ebx
            //   7516                 | je                  0xb7
            //   ff7510               | push                1
            //   ff36                 | push                dword ptr [ebp + 0xc]
            //   68????????           |                     

        $sequence_15 = { 0f8496000000 395d0c 0f848d000000 6a07 ebdd 3bf3 }
            // n = 6, score = 600
            //   0f8496000000         | je                  0x25
            //   395d0c               | inc                 ecx
            //   0f848d000000         | mov                 ecx, 4
            //   6a07                 | inc                 ecx
            //   ebdd                 | cmp                 esi, ecx
            //   3bf3                 | je                  0x66

        $sequence_16 = { 4803542460 41ff5220 4c8b442460 e9???????? }
            // n = 4, score = 500
            //   4803542460           | push                ebx
            //   41ff5220             | dec                 ebp
            //   4c8b442460           | cmp                 ebp, edi
            //   e9????????           |                     

        $sequence_17 = { 488b9424a8000000 4533c9 4533c0 ff5028 }
            // n = 4, score = 500
            //   488b9424a8000000     | mov                 ecx, 0x80000001
            //   4533c9               | test                eax, eax
            //   4533c0               | jne                 0x6a
            //   ff5028               | dec                 esp

        $sequence_18 = { eb2c 8b05???????? 413bc5 7528 493bfd 7423 41b904000000 }
            // n = 7, score = 500
            //   eb2c                 | dec                 ecx
            //   8b05????????         |                     
            //   413bc5               | cmp                 edi, ebp
            //   7528                 | je                  0xdf
            //   493bfd               | inc                 ecx
            //   7423                 | cmp                 esi, ebp
            //   41b904000000         | dec                 ecx

        $sequence_19 = { 418d5620 498bcf ff15???????? 4c8bf0 }
            // n = 4, score = 500
            //   418d5620             | mov                 ebx, ecx
            //   498bcf               | dec                 ebp
            //   ff15????????         |                     
            //   4c8bf0               | test                eax, eax

        $sequence_20 = { 4533f6 488b0b 2580000000 418d5620 }
            // n = 4, score = 500
            //   4533f6               | sub                 esp, 0x20
            //   488b0b               | dec                 esp
            //   2580000000           | mov                 eax, dword ptr [ecx + 8]
            //   418d5620             | dec                 eax

        $sequence_21 = { 4c8b18 488b542460 4533c9 488bc8 }
            // n = 4, score = 500
            //   4c8b18               | push                ebx
            //   488b542460           | dec                 eax
            //   4533c9               | test                ecx, ecx
            //   488bc8               | je                  7

        $sequence_22 = { bb57000000 e8???????? 413bc5 7446 }
            // n = 4, score = 500
            //   bb57000000           | je                  0xa4
            //   e8????????           |                     
            //   413bc5               | inc                 ecx
            //   7446                 | mov                 eax, 3

        $sequence_23 = { 498bcb 492bd0 4803542460 41ff5220 }
            // n = 4, score = 500
            //   498bcb               | je                  0x17
            //   492bd0               | dec                 ecx
            //   4803542460           | mov                 edx, ebp
            //   41ff5220             | dec                 eax

        $sequence_24 = { 0f84ac000000 41b807000000 ebd7 493bfd 0f849b000000 }
            // n = 5, score = 500
            //   0f84ac000000         | cmp                 edi, ebp
            //   41b807000000         | je                  0xa4
            //   ebd7                 | inc                 ecx
            //   493bfd               | cmp                 esi, ebp
            //   0f849b000000         | je                  0xb2

        $sequence_25 = { ebbd 493bfd 0f8481000000 413bf5 747c }
            // n = 5, score = 500
            //   ebbd                 | je                  0xbb
            //   493bfd               | inc                 ecx
            //   0f8481000000         | cmp                 esi, ebp
            //   413bf5               | je                  0xb2
            //   747c                 | dec                 ecx

        $sequence_26 = { 493bfd 0f84d9000000 413bf5 0f84d0000000 }
            // n = 4, score = 500
            //   493bfd               | cmp                 edi, ebp
            //   0f84d9000000         | je                  0xa4
            //   413bf5               | dec                 ecx
            //   0f84d0000000         | cmp                 edi, ebp

        $sequence_27 = { 493bfd 0f84b5000000 413bf5 0f84ac000000 }
            // n = 4, score = 500
            //   493bfd               | inc                 ecx
            //   0f84b5000000         | mov                 eax, 7
            //   413bf5               | jmp                 0xffffffd9
            //   0f84ac000000         | dec                 ecx

        $sequence_28 = { e8???????? e9???????? 493bfd 0f84b5000000 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   e9????????           |                     
            //   493bfd               | je                  0xd6
            //   0f84b5000000         | jmp                 0xffffffbf

        $sequence_29 = { 493bfd 0f849b000000 413bf5 0f8492000000 }
            // n = 4, score = 500
            //   493bfd               | dec                 ecx
            //   0f849b000000         | cmp                 edi, ebp
            //   413bf5               | je                  0xa1
            //   0f8492000000         | inc                 ecx

        $sequence_30 = { 5f c3 4053 4883ec20 4c8b4108 488bd9 }
            // n = 6, score = 500
            //   5f                   | mov                 eax, dword ptr [ebp - 4]
            //   c3                   | cmp                 esi, ebx
            //   4053                 | je                  0x1b
            //   4883ec20             | xor                 eax, 0x4d5319be
            //   4c8b4108             | dec                 esp
            //   488bd9               | mov                 dword ptr [esp + 0x20], ebp

        $sequence_31 = { 4c896c2420 e8???????? 4c8b442468 488b0d???????? }
            // n = 4, score = 500
            //   4c896c2420           | push                0
            //   e8????????           |                     
            //   4c8b442468           | pop                 ebp
            //   488b0d????????       |                     

        $sequence_32 = { e8???????? 4c8b1d???????? ba0d000000 41834b3401 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   4c8b1d????????       |                     
            //   ba0d000000           | lea                 eax, [esp + 0x10]
            //   41834b3401           | push                eax

        $sequence_33 = { 33d2 89442448 ff15???????? 33d2 }
            // n = 4, score = 400
            //   33d2                 | dec                 esp
            //   89442448             | mov                 eax, dword ptr [esp + 0x60]
            //   ff15????????         |                     
            //   33d2                 | dec                 ecx

        $sequence_34 = { 3decc7eea6 0f84e8000000 3d0470a8c4 0f8486000000 }
            // n = 4, score = 400
            //   3decc7eea6           | push                dword ptr [ebp - 0xc]
            //   0f84e8000000         | add                 esi, 0x3c6ef35f
            //   3d0470a8c4           | mov                 dword ptr [ebp + 0xc], esi
            //   0f8486000000         | lea                 esi, [ebp + 0xc]

        $sequence_35 = { 415c 5f c3 bb01000000 e9???????? }
            // n = 5, score = 400
            //   415c                 | push                ebx
            //   5f                   | dec                 eax
            //   c3                   | sub                 esp, 0x20
            //   bb01000000           | dec                 esp
            //   e9????????           |                     

        $sequence_36 = { ff15???????? 4883f8ff 488bf8 7445 488d842488000000 }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   4883f8ff             | ret                 4
            //   488bf8               | push                0
            //   7445                 | push                1
            //   488d842488000000     | pop                 ebx

        $sequence_37 = { 4821742428 4c8d8424c8000000 488d542428 488d4c2450 4533c9 e8???????? }
            // n = 6, score = 400
            //   4821742428           | pop                 ebx
            //   4c8d8424c8000000     | mov                 esp, ebp
            //   488d542428           | pop                 ebp
            //   488d4c2450           | ret                 4
            //   4533c9               | push                0
            //   e8????????           |                     

        $sequence_38 = { 33d2 ff15???????? 4821742428 4c8d8424c8000000 }
            // n = 4, score = 400
            //   33d2                 | ret                 4
            //   ff15????????         |                     
            //   4821742428           | xor                 eax, 0x9d2a49b1
            //   4c8d8424c8000000     | push                eax

        $sequence_39 = { 33d2 3bc2 0f85bd000000 33c0 89942498000000 }
            // n = 5, score = 400
            //   33d2                 | dec                 eax
            //   3bc2                 | mov                 edx, dword ptr [esp + 0x60]
            //   0f85bd000000         | inc                 ebp
            //   33c0                 | xor                 ecx, ecx
            //   89942498000000       | dec                 eax

        $sequence_40 = { e8???????? f7d0 eb07 8b8424c8000000 3dcad2b74e }
            // n = 5, score = 400
            //   e8????????           |                     
            //   f7d0                 | push                1
            //   eb07                 | push                dword ptr [esp + 0x10]
            //   8b8424c8000000       | mov                 eax, dword ptr [esp + 0xc]
            //   3dcad2b74e           | pop                 edi

        $sequence_41 = { 33f6 46 8945f8 85c0 }
            // n = 4, score = 400
            //   33f6                 | pop                 esp
            //   46                   | pop                 edi
            //   8945f8               | dec                 eax
            //   85c0                 | mov                 ebp, dword ptr [esp + 0x50]

        $sequence_42 = { 817424105085b8ed 33ff 47 57 be???????? 56 8d542418 }
            // n = 7, score = 400
            //   817424105085b8ed     | mov                 esi, dword ptr [ebp + 0xc]
            //   33ff                 | push                dword ptr [ebp - 8]
            //   47                   | imul                esi, esi, 0x19660d
            //   57                   | push                dword ptr [ebp - 0xc]
            //   be????????           |                     
            //   56                   | push                dword ptr [ebp - 8]
            //   8d542418             | imul                esi, esi, 0x19660d

        $sequence_43 = { ff15???????? 8945fc 85c0 741a 6804010000 8d4f10 51 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   8945fc               | cmp                 ebp, edi
            //   85c0                 | je                  0x17
            //   741a                 | dec                 ecx
            //   6804010000           | mov                 edx, ebp
            //   8d4f10               | dec                 eax
            //   51                   | or                  ecx, 0xffffffff

        $sequence_44 = { 33c0 89942498000000 899424a8000000 8984249c000000 }
            // n = 4, score = 400
            //   33c0                 | dec                 eax
            //   89942498000000       | add                 edx, dword ptr [esp + 0x60]
            //   899424a8000000       | inc                 ecx
            //   8984249c000000       | call                dword ptr [edx + 0x20]

        $sequence_45 = { ff75f4 81c65ff36e3c 89750c 8d750c e8???????? 8bf0 3bf3 }
            // n = 7, score = 400
            //   ff75f4               | inc                 ecx
            //   81c65ff36e3c         | cmp                 eax, ebp
            //   89750c               | jne                 0x2a
            //   8d750c               | dec                 ecx
            //   e8????????           |                     
            //   8bf0                 | cmp                 edi, ebp
            //   3bf3                 | je                  0x2a

        $sequence_46 = { 0f86af030000 488b4a34 813948545450 740c 8139504f5354 }
            // n = 5, score = 400
            //   0f86af030000         | dec                 eax
            //   488b4a34             | mov                 ecx, 0x80000001
            //   813948545450         | test                eax, eax
            //   740c                 | jne                 0x6c
            //   8139504f5354         | dec                 esp

        $sequence_47 = { 895dfc e8???????? 8945f8 33ff }
            // n = 4, score = 400
            //   895dfc               | jmp                 5
            //   e8????????           |                     
            //   8945f8               | mov                 esi, dword ptr [ebp + 0xc]
            //   33ff                 | push                dword ptr [ebp - 8]

        $sequence_48 = { 4d8bc4 33d2 ff15???????? 488bf8 }
            // n = 4, score = 400
            //   4d8bc4               | dec                 ecx
            //   33d2                 | mov                 edx, ebp
            //   ff15????????         |                     
            //   488bf8               | dec                 eax

        $sequence_49 = { 4883c104 4883c208 4983e801 75e4 8b442420 83f801 }
            // n = 6, score = 400
            //   4883c104             | lea                 eax, [esp + 0xc8]
            //   4883c208             | dec                 eax
            //   4983e801             | lea                 edx, [esp + 0x28]
            //   75e4                 | test                eax, eax
            //   8b442420             | je                  0xfffffd00
            //   83f801               | inc                 ebp

        $sequence_50 = { c3 6a00 6800004000 6a00 ff15???????? a3???????? }
            // n = 6, score = 400
            //   c3                   | dec                 eax
            //   6a00                 | lea                 eax, [esp + 0x40]
            //   6800004000           | je                  0x10
            //   6a00                 | dec                 eax
            //   ff15????????         |                     
            //   a3????????           |                     

        $sequence_51 = { ff33 50 6810040000 ff15???????? 8945fc }
            // n = 5, score = 400
            //   ff33                 | add                 esp, 0x20
            //   50                   | inc                 ecx
            //   6810040000           | pop                 ebp
            //   ff15????????         |                     
            //   8945fc               | inc                 ecx

        $sequence_52 = { 8945f8 33ff eb03 8b750c ff75f8 69f60d661900 ff75f4 }
            // n = 7, score = 400
            //   8945f8               | inc                 ecx
            //   33ff                 | mov                 ecx, 4
            //   eb03                 | dec                 ecx
            //   8b750c               | cmp                 edi, ebp
            //   ff75f8               | je                  0x66
            //   69f60d661900         | inc                 ecx
            //   ff75f4               | cmp                 esi, ebp

        $sequence_53 = { 483bc3 488b4550 4c8bc3 410f94c1 33d2 4889442420 }
            // n = 6, score = 400
            //   483bc3               | dec                 eax
            //   488b4550             | and                 dword ptr [esp + 0x28], esi
            //   4c8bc3               | dec                 esp
            //   410f94c1             | lea                 eax, [esp + 0xc8]
            //   33d2                 | jne                 0xfffffff7
            //   4889442420           | jmp                 8

        $sequence_54 = { 498be9 e8???????? 4885c0 488bf0 0f84a3000000 }
            // n = 5, score = 400
            //   498be9               | ret                 4
            //   e8????????           |                     
            //   4885c0               | pop                 ebp
            //   488bf0               | ret                 4
            //   0f84a3000000         | push                0

        $sequence_55 = { 418b44241c 488d5e10 4533f6 488b0b }
            // n = 4, score = 400
            //   418b44241c           | lock add            dword ptr [ecx + 0x56], -1
            //   488d5e10             | test                eax, eax
            //   4533f6               | jne                 0x4e
            //   488b0b               | jne                 7

        $sequence_56 = { 488b572c 4533c9 448bc0 498bcd ff5320 }
            // n = 5, score = 400
            //   488b572c             | lea                 ecx, [esp + 0xd0]
            //   4533c9               | xor                 edx, edx
            //   448bc0               | dec                 eax
            //   498bcd               | and                 dword ptr [esp + 0x28], esi
            //   ff5320               | dec                 esp

        $sequence_57 = { 8db4083089b9ed 57 8d45f4 50 8b450c }
            // n = 5, score = 400
            //   8db4083089b9ed       | je                  0x66
            //   57                   | mov                 edx, esi
            //   8d45f4               | dec                 eax
            //   50                   | mov                 ecx, edi
            //   8b450c               | dec                 ecx

        $sequence_58 = { 57 4883ec20 8b05???????? 8364243800 }
            // n = 4, score = 400
            //   57                   | xor                 ecx, ecx
            //   4883ec20             | dec                 ecx
            //   8b05????????         |                     
            //   8364243800           | mov                 ebp, ecx

        $sequence_59 = { 8945f8 85c0 7551 ff33 50 }
            // n = 5, score = 400
            //   8945f8               | mov                 eax, esi
            //   85c0                 | dec                 eax
            //   7551                 | mov                 esi, dword ptr [esp + 0x58]
            //   ff33                 | dec                 eax
            //   50                   | add                 esp, 0x20

        $sequence_60 = { 4c8d8424d0000000 48c7c101000080 ff15???????? 85c0 7568 4c8d8c24d0000000 }
            // n = 6, score = 400
            //   4c8d8424d0000000     | pop                 ebx
            //   48c7c101000080       | mov                 esp, ebp
            //   ff15????????         |                     
            //   85c0                 | pop                 ebp
            //   7568                 | ret                 4
            //   4c8d8c24d0000000     | mov                 esp, ebp

        $sequence_61 = { e8???????? 85c0 0f84fafcffff 4533c9 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   85c0                 | ret                 4
            //   0f84fafcffff         | mov                 esp, ebp
            //   4533c9               | pop                 ebp

        $sequence_62 = { 50 ff7310 ff15???????? 33d2 89b7184a0000 }
            // n = 5, score = 400
            //   50                   | dec                 ebp
            //   ff7310               | cmp                 ebp, edi
            //   ff15????????         |                     
            //   33d2                 | je                  0x1a
            //   89b7184a0000         | dec                 ecx

        $sequence_63 = { 8d4508 50 56 e8???????? 59 59 8945f0 }
            // n = 7, score = 300
            //   8d4508               | add                 edi, ebp
            //   50                   | cmp                 al, byte ptr [edi + 4]
            //   56                   | jb                  8
            //   e8????????           |                     
            //   59                   | push                edi
            //   59                   | add                 eax, 0x1e
            //   8945f0               | push                eax

        $sequence_64 = { e8???????? 8945ec 3bc3 0f84ad010000 53 8d4de4 51 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   8945ec               | dec                 esp
            //   3bc3                 | lea                 ecx, [esp + 0x40]
            //   0f84ad010000         | dec                 esp
            //   53                   | lea                 eax, [esp + 0x40]
            //   8d4de4               | je                  0x10
            //   51                   | dec                 eax

        $sequence_65 = { ff15???????? eb22 ff7518 ff7514 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   eb22                 | je                  0x2a
            //   ff7518               | mov                 edi, dword ptr [ebx + 0x10]
            //   ff7514               | dec                 eax

        $sequence_66 = { 4885c9 7405 e8???????? 4883c428 c3 4053 }
            // n = 6, score = 300
            //   4885c9               | mov                 edx, dword ptr [esp + 0xa8]
            //   7405                 | inc                 ebp
            //   e8????????           |                     
            //   4883c428             | xor                 ecx, ecx
            //   c3                   | inc                 ebp
            //   4053                 | xor                 eax, eax

        $sequence_67 = { 0f86ea000000 8b4508 8d843800ffffff 50 }
            // n = 4, score = 300
            //   0f86ea000000         | lea                 eax, [esp + 0x40]
            //   8b4508               | dec                 esp
            //   8d843800ffffff       | lea                 ecx, [esp + 0x40]
            //   50                   | dec                 eax

        $sequence_68 = { 493bc5 742f 488d4810 ff15???????? }
            // n = 4, score = 300
            //   493bc5               | cmp                 dword ptr [ecx], 0x54534f50
            //   742f                 | jne                 0x3af
            //   488d4810             | dec                 eax
            //   ff15????????         |                     

        $sequence_69 = { 4c8bc6 ff15???????? 488bd8 493bc7 }
            // n = 4, score = 300
            //   4c8bc6               | add                 ecx, 4
            //   ff15????????         |                     
            //   488bd8               | dec                 eax
            //   493bc7               | add                 edx, 8

        $sequence_70 = { a1???????? 35b1492a9d 50 8bd6 e8???????? eb02 33c0 }
            // n = 7, score = 300
            //   a1????????           |                     
            //   35b1492a9d           | mov                 esp, ebp
            //   50                   | pop                 ebp
            //   8bd6                 | ret                 4
            //   e8????????           |                     
            //   eb02                 | push                0
            //   33c0                 | pop                 ebp

        $sequence_71 = { 8b45fc 0fb700 8bc8 81e100f00000 }
            // n = 4, score = 300
            //   8b45fc               | lea                 eax, [ebp - 0x18]
            //   0fb700               | push                eax
            //   8bc8                 | push                edi
            //   81e100f00000         | xor                 edx, edx

        $sequence_72 = { 33c0 e8???????? 33c9 41 85c0 }
            // n = 5, score = 300
            //   33c0                 | lea                 ecx, [esp + 0x40]
            //   e8????????           |                     
            //   33c9                 | je                  0x10
            //   41                   | dec                 eax
            //   85c0                 | lea                 eax, [esp + 0x40]

        $sequence_73 = { 8be5 5d c20400 8325????????00 6a00 68???????? }
            // n = 6, score = 300
            //   8be5                 | je                  0x97
            //   5d                   | imul                esi, esi, 0x19660d
            //   c20400               | push                dword ptr [ebp - 0xc]
            //   8325????????00       |                     
            //   6a00                 | add                 esi, 0x3c6ef35f
            //   68????????           |                     

        $sequence_74 = { 85c0 7505 6a08 58 eb69 ff15???????? }
            // n = 6, score = 300
            //   85c0                 | mov                 esi, eax
            //   7505                 | jmp                 0x39
            //   6a08                 | dec                 eax
            //   58                   | lea                 eax, [0xffffd695]
            //   eb69                 | dec                 eax
            //   ff15????????         |                     

        $sequence_75 = { 740e 44893d???????? 44893d???????? 488d442440 4c8d4c2440 4c8d442440 }
            // n = 6, score = 300
            //   740e                 | push                edi
            //   44893d????????       |                     
            //   44893d????????       |                     
            //   488d442440           | dec                 eax
            //   4c8d4c2440           | sub                 esp, 0x20
            //   4c8d442440           | and                 dword ptr [esp + 0x38], 0

        $sequence_76 = { 4d3bef 7415 498bd5 4883c9ff ff15???????? 8bc8 }
            // n = 6, score = 300
            //   4d3bef               | inc                 esp
            //   7415                 | mov                 eax, eax
            //   498bd5               | dec                 ecx
            //   4883c9ff             | mov                 ecx, ebp
            //   ff15????????         |                     
            //   8bc8                 | call                dword ptr [ebx + 0x20]

        $sequence_77 = { 8945f0 ff15???????? 83c068 50 e8???????? 8bf0 8975f4 }
            // n = 7, score = 300
            //   8945f0               | test                eax, eax
            //   ff15????????         |                     
            //   83c068               | dec                 eax
            //   50                   | lea                 eax, [0xffffd695]
            //   e8????????           |                     
            //   8bf0                 | dec                 eax
            //   8975f4               | test                eax, eax

        $sequence_78 = { c9 c20800 55 8bec 81ec1c010000 8d4807 83e1f8 }
            // n = 7, score = 200
            //   c9                   | call                dword ptr [edx + 0x20]
            //   c20800               | dec                 esp
            //   55                   | mov                 eax, dword ptr [esp + 0x60]
            //   8bec                 | dec                 eax
            //   81ec1c010000         | mov                 edx, dword ptr [esp + 0xa8]
            //   8d4807               | inc                 ebp
            //   83e1f8               | xor                 ecx, ecx

        $sequence_79 = { ffb72c080000 e8???????? 5e 5d 5b c3 eb10 }
            // n = 7, score = 200
            //   ffb72c080000         | mov                 edi, eax
            //   e8????????           |                     
            //   5e                   | dec                 ebp
            //   5d                   | mov                 eax, esp
            //   5b                   | xor                 edx, edx
            //   c3                   | dec                 eax
            //   eb10                 | mov                 edi, eax

        $sequence_80 = { 488bf0 eb34 488d0595d6ffff 4885c0 }
            // n = 4, score = 200
            //   488bf0               | cmp                 eax, ebx
            //   eb34                 | dec                 eax
            //   488d0595d6ffff       | mov                 eax, dword ptr [ebp + 0x50]
            //   4885c0               | dec                 esp

        $sequence_81 = { 488b15???????? 4c8d442468 48c7c101000080 ff15???????? }
            // n = 4, score = 200
            //   488b15????????       |                     
            //   4c8d442468           | dec                 esp
            //   48c7c101000080       | mov                 esi, eax
            //   ff15????????         |                     

        $sequence_82 = { a1???????? 83c01e 50 ff15???????? a1???????? 33c9 }
            // n = 6, score = 200
            //   a1????????           |                     
            //   83c01e               | dec                 esp
            //   50                   | mov                 eax, ebx
            //   ff15????????         |                     
            //   a1????????           |                     
            //   33c9                 | inc                 ecx

        $sequence_83 = { e8???????? 488b0d???????? 448be0 f0834156ff 85c0 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   448be0               | inc                 ecx
            //   f0834156ff           | lea                 edx, [esi + 0x20]
            //   85c0                 | dec                 ecx

        $sequence_84 = { 3a4704 7206 57 e8???????? a1???????? 83c01e 50 }
            // n = 7, score = 200
            //   3a4704               | mov                 dword ptr [esp + 0x20], eax
            //   7206                 | dec                 eax
            //   57                   | cmp                 eax, ebx
            //   e8????????           |                     
            //   a1????????           |                     
            //   83c01e               | dec                 eax
            //   50                   | mov                 eax, dword ptr [ebp + 0x50]

        $sequence_85 = { 7505 8d5857 eb15 488b05???????? 89702a 48897d00 eb17 }
            // n = 7, score = 200
            //   7505                 | mov                 ecx, dword ptr [ebx]
            //   8d5857               | and                 eax, 0x80
            //   eb15                 | inc                 ecx
            //   488b05????????       |                     
            //   89702a               | lea                 edx, [esi + 0x20]
            //   48897d00             | dec                 ecx
            //   eb17                 | inc                 edi

        $sequence_86 = { 83839c000000ff 397818 0f852ffcffff 33c0 }
            // n = 4, score = 200
            //   83839c000000ff       | mov                 dword ptr [ebp - 0x20], 0x3be24e7
            //   397818               | mov                 dword ptr [ebp - 0x28], eax
            //   0f852ffcffff         | jne                 0x27
            //   33c0                 | dec                 ecx

        $sequence_87 = { 488b0d???????? 488bfa 4883c12e ff15???????? eb0b }
            // n = 5, score = 200
            //   488b0d????????       |                     
            //   488bfa               | dec                 ecx
            //   4883c12e             | mov                 ecx, edi
            //   ff15????????         |                     
            //   eb0b                 | dec                 eax

        $sequence_88 = { 83c01e 50 ffd6 a1???????? }
            // n = 4, score = 200
            //   83c01e               | pop                 esp
            //   50                   | pop                 edi
            //   ffd6                 | ret                 
            //   a1????????           |                     

        $sequence_89 = { 8d4604 66d3e0 66098310170000 8d4103 }
            // n = 4, score = 200
            //   8d4604               | test                eax, eax
            //   66d3e0               | je                  0x1bb
            //   66098310170000       | cmp                 dword ptr [esp + 0x4c], ebx
            //   8d4103               | je                  0x2b

        $sequence_90 = { 8be5 5d c3 0fb708 6683f902 751c }
            // n = 6, score = 200
            //   8be5                 | xor                 ecx, ecx
            //   5d                   | dec                 eax
            //   c3                   | mov                 ecx, eax
            //   0fb708               | inc                 ecx
            //   6683f902             | call                dword ptr [ebx + 0x18]
            //   751c                 | dec                 ecx

        $sequence_91 = { 83a78c00000000 33c0 c3 51 e8???????? }
            // n = 5, score = 200
            //   83a78c00000000       | dec                 ecx
            //   33c0                 | mov                 ecx, edi
            //   c3                   | dec                 esp
            //   51                   | mov                 esi, eax
            //   e8????????           |                     

        $sequence_92 = { 8b9314170000 83432801 b910000000 8d42f3 2aca }
            // n = 5, score = 200
            //   8b9314170000         | inc                 esi
            //   83432801             | lahf                
            //   b910000000           | arpl                word ptr fs:[eax + 0x10], di
            //   8d42f3               | jo                  0x63
            //   2aca                 | cmp                 eax, 0x6e3f640e

        $sequence_93 = { 83c136 83caff f00fc111 33f6 }
            // n = 4, score = 200
            //   83c136               | mov                 eax, dword ptr [esp + 0x30]
            //   83caff               | neg                 eax
            //   f00fc111             | je                  0x1d0
            //   33f6                 | mov                 eax, dword ptr [edx + 0x4c]

        $sequence_94 = { e8???????? 488b0d???????? 4883c12e ff15???????? }
            // n = 4, score = 200
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   4883c12e             | dec                 eax
            //   ff15????????         |                     

        $sequence_95 = { 4c8b1d???????? 418b4356 85c0 75e6 }
            // n = 4, score = 200
            //   4c8b1d????????       |                     
            //   418b4356             | mov                 ecx, edi
            //   85c0                 | dec                 esp
            //   75e6                 | mov                 esi, eax

        $sequence_96 = { a1???????? 8b4c2404 8908 83c01e 50 ff15???????? }
            // n = 6, score = 200
            //   a1????????           |                     
            //   8b4c2404             | mov                 ebx, 1
            //   8908                 | mov                 eax, dword ptr [esp + 0x30]
            //   83c01e               | inc                 ecx
            //   50                   | pop                 esp
            //   ff15????????         |                     

        $sequence_97 = { 8975f4 ffd7 8b1d???????? 6a3a }
            // n = 4, score = 200
            //   8975f4               | pop                 edi
            //   ffd7                 | ret                 
            //   8b1d????????         |                     
            //   6a3a                 | mov                 ebx, 1

        $sequence_98 = { 0f8495000000 8b3d???????? 6aff 68806967ff 56 ff35???????? e8???????? }
            // n = 7, score = 200
            //   0f8495000000         | xor                 ecx, ecx
            //   8b3d????????         |                     
            //   6aff                 | dec                 eax
            //   68806967ff           | mov                 ecx, edi
            //   56                   | mov                 cx, 1
            //   ff35????????         |                     
            //   e8????????           |                     

        $sequence_99 = { a1???????? 83c036 83c9ff f00fc108 85db 0f8425010000 68???????? }
            // n = 7, score = 200
            //   a1????????           |                     
            //   83c036               | sete                cl
            //   83c9ff               | xor                 edx, edx
            //   f00fc108             | dec                 eax
            //   85db                 | mov                 dword ptr [esp + 0x20], eax
            //   0f8425010000         | inc                 ecx
            //   68????????           |                     

        $sequence_100 = { c3 33c0 483bc8 7458 488b5128 483bd0 }
            // n = 6, score = 200
            //   c3                   | push                dword ptr [ebp + 0x10]
            //   33c0                 | inc                 esi
            //   483bc8               | xor                 eax, dword ptr [ecx*4 + 0x3be6210]
            //   7458                 | test                edi, edi
            //   488b5128             | jne                 0xffffffda
            //   483bd0               | not                 eax

        $sequence_101 = { e9???????? 83f916 0f8fa7080000 0f8415080000 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   83f916               | mov                 ecx, 0xf318ef74
            //   0f8fa7080000         | popal               
            //   0f8415080000         | dec                 edi

        $sequence_102 = { e9???????? 83e908 74eb 2bcb 0f84fa000000 2bcb }
            // n = 6, score = 200
            //   e9????????           |                     
            //   83e908               | mov                 edi, dword ptr [ecx]
            //   74eb                 | inc                 edx
            //   2bcb                 | cmp                 edx, eax
            //   0f84fa000000         | jne                 0x220
            //   2bcb                 | mov                 eax, dword ptr [esp + 0x60]

        $sequence_103 = { 33d2 e8???????? 44892d???????? 33c9 44892d???????? e8???????? 488bcf }
            // n = 7, score = 200
            //   33d2                 | ret                 
            //   e8????????           |                     
            //   44892d????????       |                     
            //   33c9                 | push                0
            //   44892d????????       |                     
            //   e8????????           |                     
            //   488bcf               | push                0x400000

        $sequence_104 = { 66b90100 4889442420 e8???????? 3bc3 0f859b000000 }
            // n = 5, score = 200
            //   66b90100             | push                0
            //   4889442420           | ret                 
            //   e8????????           |                     
            //   3bc3                 | push                0
            //   0f859b000000         | push                0x400000

        $sequence_105 = { 5e 5b c20800 51 53 57 6884000000 }
            // n = 7, score = 200
            //   5e                   | dec                 esp
            //   5b                   | mov                 eax, dword ptr [esp + 0x60]
            //   c20800               | dec                 esp
            //   51                   | mov                 ebx, dword ptr [eax]
            //   53                   | dec                 eax
            //   57                   | mov                 edx, dword ptr [esp + 0x60]
            //   6884000000           | inc                 ebp

        $sequence_106 = { 8b442404 56 e8???????? 884604 a1???????? 83c01e 50 }
            // n = 7, score = 200
            //   8b442404             | pop                 esp
            //   56                   | pop                 edi
            //   e8????????           |                     
            //   884604               | ret                 
            //   a1????????           |                     
            //   83c01e               | mov                 ebx, 1
            //   50                   | inc                 ecx

        $sequence_107 = { 4883c12e ff15???????? 448b05???????? 488bd3 b92ab5f293 e8???????? 4885c0 }
            // n = 7, score = 200
            //   4883c12e             | dec                 eax
            //   ff15????????         |                     
            //   448b05????????       |                     
            //   488bd3               | test                eax, eax
            //   b92ab5f293           | dec                 ecx
            //   e8????????           |                     
            //   4885c0               | inc                 edi

        $sequence_108 = { e8???????? 8945f8 85c0 0f851c050000 ff7508 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8945f8               | lea                 eax, [ebp + 8]
            //   85c0                 | push                eax
            //   0f851c050000         | push                esi
            //   ff7508               | pop                 ecx

        $sequence_109 = { 33d2 85c0 7c12 8d0c950875be03 8b39 42 3bd0 }
            // n = 7, score = 100
            //   33d2                 | jne                 0xfffffff0
            //   85c0                 | mov                 eax, dword ptr [esp + 4]
            //   7c12                 | push                ebx
            //   8d0c950875be03       | mov                 bl, byte ptr [esi]
            //   8b39                 | inc                 bl
            //   42                   | mov                 edx, 0xd
            //   3bd0                 | inc                 ecx

        $sequence_110 = { 8bd8 3bde 0f8559020000 e8???????? 6a18 }
            // n = 5, score = 100
            //   8bd8                 | mov                 dword ptr [ebp - 0x10], eax
            //   3bde                 | add                 eax, 0x68
            //   0f8559020000         | push                eax
            //   e8????????           |                     
            //   6a18                 | mov                 esi, eax

        $sequence_111 = { 0f851a020000 8b442460 3bc3 7414 8b483c 66f74401160020 7408 }
            // n = 7, score = 100
            //   0f851a020000         | or                  dword ptr [ebx + 0x34], 1
            //   8b442460             | inc                 ebp
            //   3bc3                 | xor                 ecx, ecx
            //   7414                 | inc                 ebp
            //   8b483c               | xor                 eax, eax
            //   66f74401160020       | xor                 edx, edx
            //   7408                 | xor                 ecx, ecx

        $sequence_112 = { 46 33048d1062be03 85ff 75cf f7d0 eb02 33c0 }
            // n = 7, score = 100
            //   46                   | mov                 ecx, dword ptr [esp + 4]
            //   33048d1062be03       | mov                 dword ptr [eax], ecx
            //   85ff                 | add                 eax, 0x1e
            //   75cf                 | push                eax
            //   f7d0                 | mov                 dword ptr [ebp - 0xc], esi
            //   eb02                 | call                edi
            //   33c0                 | push                0x3a

        $sequence_113 = { 8945fc ff15???????? eb26 c745fc08000000 eb1d }
            // n = 5, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 0xc], esi
            //   ff15????????         |                     
            //   eb26                 | jmp                 0x24
            //   c745fc08000000       | push                dword ptr [ebp + 0x18]
            //   eb1d                 | push                dword ptr [ebp + 0x14]

        $sequence_114 = { 0f859d010000 e8???????? 85c0 0f849d010000 395c244c 7407 }
            // n = 6, score = 100
            //   0f859d010000         | dec                 eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f849d010000         | dec                 esp
            //   395c244c             | mov                 esp, eax
            //   7407                 | xor                 edx, edx

        $sequence_115 = { 46 9f 64637810 705d 3d0e643f6e b974ef18f3 61 }
            // n = 7, score = 100
            //   46                   | mov                 dword ptr [edi + 0x4a18], esi
            //   9f                   | cmp                 dword ptr [edi + 0x4a1c], edx
            //   64637810             | je                  0x10
            //   705d                 | dec                 eax
            //   3d0e643f6e           | lea                 eax, [esp + 0x40]
            //   b974ef18f3           | dec                 esp
            //   61                   | lea                 ecx, [esp + 0x40]

        $sequence_116 = { 56 57 35fa446809 33ff 57 50 }
            // n = 6, score = 100
            //   56                   | mov                 ecx, dword ptr [esp + 4]
            //   57                   | mov                 dword ptr [eax], ecx
            //   35fa446809           | add                 eax, 0x1e
            //   33ff                 | push                eax
            //   57                   | mov                 eax, dword ptr [eax + 0x36]
            //   50                   | test                eax, eax

        $sequence_117 = { ff75f8 56 ff15???????? 6a01 }
            // n = 4, score = 100
            //   ff75f8               | dec                 esp
            //   56                   | lea                 eax, [esp + 0x40]
            //   ff15????????         |                     
            //   6a01                 | dec                 eax

        $sequence_118 = { 7420 56 ff7508 8d45e8 }
            // n = 4, score = 100
            //   7420                 | add                 ecx, 0x36
            //   56                   | or                  edx, 0xffffffff
            //   ff7508               | lock xadd           dword ptr [ecx], edx
            //   8d45e8               | xor                 esi, esi

    condition:
        7 of them and filesize < 802816
}