rule win_eagerbee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.eagerbee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.eagerbee"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b5510 488b4b38 4c8bc7 482bd7 e8???????? }
            // n = 5, score = 100
            //   488b5510             | add                 esp, 0x30
            //   488b4b38             | inc                 ecx
            //   4c8bc7               | pop                 ebp
            //   482bd7               | xor                 eax, eax
            //   e8????????           |                     

        $sequence_1 = { 498b4310 410fb7c8 66f7d1 66c1e908 880c02 41ff4328 458b4b28 }
            // n = 7, score = 100
            //   498b4310             | mov                 byte ptr [esp + 0x10a], 0xd
            //   410fb7c8             | mov                 byte ptr [esp + 0x10b], 0xa
            //   66f7d1               | inc                 esp
            //   66c1e908             | mov                 byte ptr [esp + 0x10c], bh
            //   880c02               | inc                 esp
            //   41ff4328             | add                 byte ptr [esp + 0x130], dh
            //   458b4b28             | mov                 byte ptr [esp + 0x10a], 0xd

        $sequence_2 = { 498980b0010000 c68424a000000057 c68424a100000053 c68424a200000041 c68424a300000053 c68424a400000074 c68424a500000061 }
            // n = 7, score = 100
            //   498980b0010000       | call                dword ptr [eax + 0x58]
            //   c68424a000000057     | dec                 eax
            //   c68424a100000053     | lea                 edx, [esp + 0xb0]
            //   c68424a200000041     | dec                 eax
            //   c68424a300000053     | mov                 dword ptr [ebx + 0x28], eax
            //   c68424a400000074     | mov                 byte ptr [esp + 0x101], 0x57
            //   c68424a500000061     | inc                 eax

        $sequence_3 = { 488364242000 b8fffe0000 4c8d4c2444 488d542440 41b802000000 488bcb 6689442440 }
            // n = 7, score = 100
            //   488364242000         | inc                 esp
            //   b8fffe0000           | mov                 eax, dword ptr [edi + 0x94]
            //   4c8d4c2444           | dec                 esp
            //   488d542440           | mov                 esp, dword ptr [eax]
            //   41b802000000         | dec                 eax
            //   488bcb               | or                  ecx, 0xffffffff
            //   6689442440           | xor                 eax, eax

        $sequence_4 = { c787cc00000001000000 c787c800000001000000 e8???????? 488b05???????? }
            // n = 4, score = 100
            //   c787cc00000001000000     | lea    edi, [0x15267]
            //   c787c800000001000000     | and    esi, 0x1f
            //   e8????????           |                     
            //   488b05????????       |                     

        $sequence_5 = { ff15???????? 85c0 750e 035c2448 4863f3 4803f7 c646ff5f }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | mov                 dword ptr [esp + 0x58], ebp
            //   750e                 | inc                 esp
            //   035c2448             | mov                 dword ptr [esp + 0x50], esp
            //   4863f3               | inc                 esp
            //   4803f7               | mov                 dword ptr [esp + 0x54], esi
            //   c646ff5f             | dec                 eax

        $sequence_6 = { 8bc3 eb3b 4d85e4 7408 498bcc }
            // n = 5, score = 100
            //   8bc3                 | lea                 ebx, [0x1255b]
            //   eb3b                 | dec                 eax
            //   4d85e4               | lea                 edi, [0x12554]
            //   7408                 | jmp                 0x1d6e
            //   498bcc               | dec                 eax

        $sequence_7 = { 483bc3 750d ff15???????? 33c0 e9???????? 48895c2430 488d8424c0100000 }
            // n = 7, score = 100
            //   483bc3               | jne                 0xf2c
            //   750d                 | jmp                 0xf5f
            //   ff15????????         |                     
            //   33c0                 | dec                 ecx
            //   e9????????           |                     
            //   48895c2430           | inc                 ecx
            //   488d8424c0100000     | dec                 ebp

        $sequence_8 = { c787ac00000006000000 498d0443 89b7b0000000 c6473c08 488987f8160000 498d044b }
            // n = 6, score = 100
            //   c787ac00000006000000     | mov    byte ptr [esp + 0xd3], 0x73
            //   498d0443             | dec                 eax
            //   89b7b0000000         | cmp                 eax, esi
            //   c6473c08             | je                  0x130e
            //   488987f8160000       | dec                 esp
            //   498d044b             | mov                 eax, edi

        $sequence_9 = { 8b8c3888000000 41b801000000 488bd7 e8???????? 8bf0 837c3e1800 }
            // n = 6, score = 100
            //   8b8c3888000000       | inc                 cx
            //   41b801000000         | mov                 dword ptr [ebx + 0x1710], eax
            //   488bd7               | inc                 ecx
            //   e8????????           |                     
            //   8bf0                 | mov                 dword ptr [ebx + 0x1714], eax
            //   837c3e1800           | dec                 ecx

    condition:
        7 of them and filesize < 422912
}