rule win_equationdrug_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.equationdrug."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.equationdrug"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4c241c 81e6ffff0000 8b11 ff5214 8b4c2418 668bd0 8b442414 }
            // n = 7, score = 100
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   81e6ffff0000         | and                 esi, 0xffff
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   ff5214               | call                dword ptr [edx + 0x14]
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   668bd0               | mov                 dx, ax
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]

        $sequence_1 = { 8911 8bd4 894104 66896908 8bcf 8b01 8902 }
            // n = 7, score = 100
            //   8911                 | mov                 dword ptr [ecx], edx
            //   8bd4                 | mov                 edx, esp
            //   894104               | mov                 dword ptr [ecx + 4], eax
            //   66896908             | mov                 word ptr [ecx + 8], bp
            //   8bcf                 | mov                 ecx, edi
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8902                 | mov                 dword ptr [edx], eax

        $sequence_2 = { 89742418 3bc2 0f8731020000 6683ff01 0f8227020000 668b44246a 663dffff }
            // n = 7, score = 100
            //   89742418             | mov                 dword ptr [esp + 0x18], esi
            //   3bc2                 | cmp                 eax, edx
            //   0f8731020000         | ja                  0x237
            //   6683ff01             | cmp                 di, 1
            //   0f8227020000         | jb                  0x22d
            //   668b44246a           | mov                 ax, word ptr [esp + 0x6a]
            //   663dffff             | cmp                 ax, 0xffff

        $sequence_3 = { c21400 8b17 6a02 8bcf ff523c 85c0 750c }
            // n = 7, score = 100
            //   c21400               | ret                 0x14
            //   8b17                 | mov                 edx, dword ptr [edi]
            //   6a02                 | push                2
            //   8bcf                 | mov                 ecx, edi
            //   ff523c               | call                dword ptr [edx + 0x3c]
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe

        $sequence_4 = { 56 57 8bbc248c000000 57 55 50 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bbc248c000000       | mov                 edi, dword ptr [esp + 0x8c]
            //   57                   | push                edi
            //   55                   | push                ebp
            //   50                   | push                eax

        $sequence_5 = { 6a44 e8???????? 83c404 89442464 3bc3 c644245c02 740b }
            // n = 7, score = 100
            //   6a44                 | push                0x44
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   89442464             | mov                 dword ptr [esp + 0x64], eax
            //   3bc3                 | cmp                 eax, ebx
            //   c644245c02           | mov                 byte ptr [esp + 0x5c], 2
            //   740b                 | je                  0xd

        $sequence_6 = { eb02 33c0 50 8bcb c7442424ffffffff e8???????? }
            // n = 6, score = 100
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax
            //   8bcb                 | mov                 ecx, ebx
            //   c7442424ffffffff     | mov                 dword ptr [esp + 0x24], 0xffffffff
            //   e8????????           |                     

        $sequence_7 = { 83c424 c21000 8b4c2414 85c9 7406 8b01 6a01 }
            // n = 7, score = 100
            //   83c424               | add                 esp, 0x24
            //   c21000               | ret                 0x10
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   85c9                 | test                ecx, ecx
            //   7406                 | je                  8
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   6a01                 | push                1

        $sequence_8 = { 8bf0 c68424cc00000001 e8???????? 8d8c2484000000 889c24cc000000 e8???????? 8d4c240c }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   c68424cc00000001     | mov                 byte ptr [esp + 0xcc], 1
            //   e8????????           |                     
            //   8d8c2484000000       | lea                 ecx, [esp + 0x84]
            //   889c24cc000000       | mov                 byte ptr [esp + 0xcc], bl
            //   e8????????           |                     
            //   8d4c240c             | lea                 ecx, [esp + 0xc]

        $sequence_9 = { ff502c 85c0 750d 5f b800090000 5e 83c410 }
            // n = 7, score = 100
            //   ff502c               | call                dword ptr [eax + 0x2c]
            //   85c0                 | test                eax, eax
            //   750d                 | jne                 0xf
            //   5f                   | pop                 edi
            //   b800090000           | mov                 eax, 0x900
            //   5e                   | pop                 esi
            //   83c410               | add                 esp, 0x10

    condition:
        7 of them and filesize < 449536
}