rule win_etumbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.etumbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.etumbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8811 8a00 02c2 0fb6c0 8a8405fcfeffff 320437 8806 }
            // n = 7, score = 400
            //   8811                 | mov                 byte ptr [ecx], dl
            //   8a00                 | mov                 al, byte ptr [eax]
            //   02c2                 | add                 al, dl
            //   0fb6c0               | movzx               eax, al
            //   8a8405fcfeffff       | mov                 al, byte ptr [ebp + eax - 0x104]
            //   320437               | xor                 al, byte ptr [edi + esi]
            //   8806                 | mov                 byte ptr [esi], al

        $sequence_1 = { 8d45f4 6820a10700 50 68???????? }
            // n = 4, score = 300
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   6820a10700           | push                0x7a120
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_2 = { c745ac5c5c4d69 c745b063726f73 c745b46f66745c c745b85c57696e }
            // n = 4, score = 300
            //   c745ac5c5c4d69       | mov                 dword ptr [ebp - 0x54], 0x694d5c5c
            //   c745b063726f73       | mov                 dword ptr [ebp - 0x50], 0x736f7263
            //   c745b46f66745c       | mov                 dword ptr [ebp - 0x4c], 0x5c74666f
            //   c745b85c57696e       | mov                 dword ptr [ebp - 0x48], 0x6e69575c

        $sequence_3 = { 8d45a4 50 6801000080 c745a4536f6674 }
            // n = 4, score = 300
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   50                   | push                eax
            //   6801000080           | push                0x80000001
            //   c745a4536f6674       | mov                 dword ptr [ebp - 0x5c], 0x74666f53

        $sequence_4 = { ffd7 2bc3 3bc6 72ed }
            // n = 4, score = 300
            //   ffd7                 | call                edi
            //   2bc3                 | sub                 eax, ebx
            //   3bc6                 | cmp                 eax, esi
            //   72ed                 | jb                  0xffffffef

        $sequence_5 = { ffd7 8b7508 8bd8 69f660ea0000 }
            // n = 4, score = 300
            //   ffd7                 | call                edi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8bd8                 | mov                 ebx, eax
            //   69f660ea0000         | imul                esi, esi, 0xea60

        $sequence_6 = { 33c7 f7d1 23c1 42 4e 75df }
            // n = 6, score = 300
            //   33c7                 | xor                 eax, edi
            //   f7d1                 | not                 ecx
            //   23c1                 | and                 eax, ecx
            //   42                   | inc                 edx
            //   4e                   | dec                 esi
            //   75df                 | jne                 0xffffffe1

        $sequence_7 = { c745b46f66745c c745b85c57696e c745bc646f7773 c745c05c5c4375 c745c47272656e c745c874566572 c745cc73696f6e }
            // n = 7, score = 300
            //   c745b46f66745c       | mov                 dword ptr [ebp - 0x4c], 0x5c74666f
            //   c745b85c57696e       | mov                 dword ptr [ebp - 0x48], 0x6e69575c
            //   c745bc646f7773       | mov                 dword ptr [ebp - 0x44], 0x73776f64
            //   c745c05c5c4375       | mov                 dword ptr [ebp - 0x40], 0x75435c5c
            //   c745c47272656e       | mov                 dword ptr [ebp - 0x3c], 0x6e657272
            //   c745c874566572       | mov                 dword ptr [ebp - 0x38], 0x72655674
            //   c745cc73696f6e       | mov                 dword ptr [ebp - 0x34], 0x6e6f6973

        $sequence_8 = { 57 0fbe38 33f6 33db }
            // n = 4, score = 300
            //   57                   | push                edi
            //   0fbe38               | movsx               edi, byte ptr [eax]
            //   33f6                 | xor                 esi, esi
            //   33db                 | xor                 ebx, ebx

        $sequence_9 = { c1e004 03c1 8bc8 81e1000000f0 7407 8bf9 }
            // n = 6, score = 300
            //   c1e004               | shl                 eax, 4
            //   03c1                 | add                 eax, ecx
            //   8bc8                 | mov                 ecx, eax
            //   81e1000000f0         | and                 ecx, 0xf0000000
            //   7407                 | je                  9
            //   8bf9                 | mov                 edi, ecx

        $sequence_10 = { c745c874566572 c745cc73696f6e c745d05c5c496e c745d47465726e c745d865742053 }
            // n = 5, score = 300
            //   c745c874566572       | mov                 dword ptr [ebp - 0x38], 0x72655674
            //   c745cc73696f6e       | mov                 dword ptr [ebp - 0x34], 0x6e6f6973
            //   c745d05c5c496e       | mov                 dword ptr [ebp - 0x30], 0x6e495c5c
            //   c745d47465726e       | mov                 dword ptr [ebp - 0x2c], 0x6e726574
            //   c745d865742053       | mov                 dword ptr [ebp - 0x28], 0x53207465

        $sequence_11 = { 81e1000000f0 7407 8bf9 c1ef18 33c7 f7d1 }
            // n = 6, score = 300
            //   81e1000000f0         | and                 ecx, 0xf0000000
            //   7407                 | je                  9
            //   8bf9                 | mov                 edi, ecx
            //   c1ef18               | shr                 edi, 0x18
            //   33c7                 | xor                 eax, edi
            //   f7d1                 | not                 ecx

        $sequence_12 = { c745d47465726e c745d865742053 c745dc65747469 c745e06e677300 }
            // n = 4, score = 300
            //   c745d47465726e       | mov                 dword ptr [ebp - 0x2c], 0x6e726574
            //   c745d865742053       | mov                 dword ptr [ebp - 0x28], 0x53207465
            //   c745dc65747469       | mov                 dword ptr [ebp - 0x24], 0x69747465
            //   c745e06e677300       | mov                 dword ptr [ebp - 0x20], 0x73676e

        $sequence_13 = { c645d720 c645d84e c645d954 c645da20 }
            // n = 4, score = 200
            //   c645d720             | mov                 byte ptr [ebp - 0x29], 0x20
            //   c645d84e             | mov                 byte ptr [ebp - 0x28], 0x4e
            //   c645d954             | mov                 byte ptr [ebp - 0x27], 0x54
            //   c645da20             | mov                 byte ptr [ebp - 0x26], 0x20

        $sequence_14 = { a1???????? 57 83f801 7507 33c0 a3???????? }
            // n = 6, score = 200
            //   a1????????           |                     
            //   57                   | push                edi
            //   83f801               | cmp                 eax, 1
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   a3????????           |                     

        $sequence_15 = { 034df0 8b5508 0355ec 8a02 }
            // n = 4, score = 200
            //   034df0               | add                 ecx, dword ptr [ebp - 0x10]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0355ec               | add                 edx, dword ptr [ebp - 0x14]
            //   8a02                 | mov                 al, byte ptr [edx]

        $sequence_16 = { 6a00 68???????? 6a00 6a00 6a00 51 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   51                   | push                ecx

        $sequence_17 = { e8???????? 85c0 75f5 53 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   75f5                 | jne                 0xfffffff7
            //   53                   | push                ebx

        $sequence_18 = { c645c653 c645c749 c645c845 c645c920 }
            // n = 4, score = 200
            //   c645c653             | mov                 byte ptr [ebp - 0x3a], 0x53
            //   c645c749             | mov                 byte ptr [ebp - 0x39], 0x49
            //   c645c845             | mov                 byte ptr [ebp - 0x38], 0x45
            //   c645c920             | mov                 byte ptr [ebp - 0x37], 0x20

        $sequence_19 = { 8811 8818 7cc3 8b450c }
            // n = 4, score = 200
            //   8811                 | mov                 byte ptr [ecx], dl
            //   8818                 | mov                 byte ptr [eax], bl
            //   7cc3                 | jl                  0xffffffc5
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_20 = { 8b4d08 034dec 8a11 8810 8b45f0 }
            // n = 5, score = 200
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   034dec               | add                 ecx, dword ptr [ebp - 0x14]
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   8810                 | mov                 byte ptr [eax], dl
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_21 = { 56 57 8b7d08 8065fe00 8d45e4 }
            // n = 5, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8065fe00             | and                 byte ptr [ebp - 2], 0
            //   8d45e4               | lea                 eax, [ebp - 0x1c]

        $sequence_22 = { c645f462 c645f56c 50 c645f665 }
            // n = 4, score = 200
            //   c645f462             | mov                 byte ptr [ebp - 0xc], 0x62
            //   c645f56c             | mov                 byte ptr [ebp - 0xb], 0x6c
            //   50                   | push                eax
            //   c645f665             | mov                 byte ptr [ebp - 0xa], 0x65

        $sequence_23 = { 8b45f4 0345f0 8b4d08 034dec }
            // n = 4, score = 200
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   0345f0               | add                 eax, dword ptr [ebp - 0x10]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   034dec               | add                 ecx, dword ptr [ebp - 0x14]

        $sequence_24 = { 83c204 3b5514 7608 83c8ff }
            // n = 4, score = 200
            //   83c204               | add                 edx, 4
            //   3b5514               | cmp                 edx, dword ptr [ebp + 0x14]
            //   7608                 | jbe                 0xa
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_25 = { 50 8d8504ffffff 50 c645e761 c645e874 c645e965 c645ea20 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d8504ffffff         | lea                 eax, [ebp - 0xfc]
            //   50                   | push                eax
            //   c645e761             | mov                 byte ptr [ebp - 0x19], 0x61
            //   c645e874             | mov                 byte ptr [ebp - 0x18], 0x74
            //   c645e965             | mov                 byte ptr [ebp - 0x17], 0x65
            //   c645ea20             | mov                 byte ptr [ebp - 0x16], 0x20

        $sequence_26 = { c645c420 c645c54d c645c653 c645c749 }
            // n = 4, score = 200
            //   c645c420             | mov                 byte ptr [ebp - 0x3c], 0x20
            //   c645c54d             | mov                 byte ptr [ebp - 0x3b], 0x4d
            //   c645c653             | mov                 byte ptr [ebp - 0x3a], 0x53
            //   c645c749             | mov                 byte ptr [ebp - 0x39], 0x49

        $sequence_27 = { 8d4a01 83c404 8bd1 c1e902 }
            // n = 4, score = 200
            //   8d4a01               | lea                 ecx, [edx + 1]
            //   83c404               | add                 esp, 4
            //   8bd1                 | mov                 edx, ecx
            //   c1e902               | shr                 ecx, 2

        $sequence_28 = { 80e10f c0e102 c0eb06 02cb }
            // n = 4, score = 200
            //   80e10f               | and                 cl, 0xf
            //   c0e102               | shl                 cl, 2
            //   c0eb06               | shr                 bl, 6
            //   02cb                 | add                 cl, bl

        $sequence_29 = { 881c2e c0e006 24c0 88442e01 8b442458 46 }
            // n = 6, score = 200
            //   881c2e               | mov                 byte ptr [esi + ebp], bl
            //   c0e006               | shl                 al, 6
            //   24c0                 | and                 al, 0xc0
            //   88442e01             | mov                 byte ptr [esi + ebp + 1], al
            //   8b442458             | mov                 eax, dword ptr [esp + 0x58]
            //   46                   | inc                 esi

        $sequence_30 = { 8d540964 52 e8???????? 83c404 }
            // n = 4, score = 200
            //   8d540964             | lea                 edx, [ecx + ecx + 0x64]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_31 = { 53 8b5c240c 56 c60200 a1???????? }
            // n = 5, score = 200
            //   53                   | push                ebx
            //   8b5c240c             | mov                 ebx, dword ptr [esp + 0xc]
            //   56                   | push                esi
            //   c60200               | mov                 byte ptr [edx], 0
            //   a1????????           |                     

        $sequence_32 = { 83c104 3b4d14 7608 83c8ff }
            // n = 4, score = 200
            //   83c104               | add                 ecx, 4
            //   3b4d14               | cmp                 ecx, dword ptr [ebp + 0x14]
            //   7608                 | jbe                 0xa
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_33 = { c645ce3b c645cf20 c645d057 c645d169 }
            // n = 4, score = 200
            //   c645ce3b             | mov                 byte ptr [ebp - 0x32], 0x3b
            //   c645cf20             | mov                 byte ptr [ebp - 0x31], 0x20
            //   c645d057             | mov                 byte ptr [ebp - 0x30], 0x57
            //   c645d169             | mov                 byte ptr [ebp - 0x2f], 0x69

        $sequence_34 = { 8b4d08 83c101 894d08 8b550c 83ea03 }
            // n = 5, score = 200
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c101               | add                 ecx, 1
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   83ea03               | sub                 edx, 3

        $sequence_35 = { 50 8bce e8???????? 8d85f4d2ffff 50 }
            // n = 5, score = 200
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8d85f4d2ffff         | lea                 eax, [ebp - 0x2d0c]
            //   50                   | push                eax

        $sequence_36 = { c68511feffff34 c68512feffff33 c68513feffff72 c68514feffff74 c68515feffff7e }
            // n = 5, score = 100
            //   c68511feffff34       | mov                 byte ptr [ebp - 0x1ef], 0x34
            //   c68512feffff33       | mov                 byte ptr [ebp - 0x1ee], 0x33
            //   c68513feffff72       | mov                 byte ptr [ebp - 0x1ed], 0x72
            //   c68514feffff74       | mov                 byte ptr [ebp - 0x1ec], 0x74
            //   c68515feffff7e       | mov                 byte ptr [ebp - 0x1eb], 0x7e

    condition:
        7 of them and filesize < 450560
}