rule win_explosive_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.explosive_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.explosive_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83460402 8b460c 83e0ef 83c801 89460c 668bc3 eb81 }
            // n = 7, score = 100
            //   83460402             | add                 dword ptr [esi + 4], 2
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   83e0ef               | and                 eax, 0xffffffef
            //   83c801               | or                  eax, 1
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   668bc3               | mov                 ax, bx
            //   eb81                 | jmp                 0xffffff83

        $sequence_1 = { 7606 2bc2 8bf0 eb02 33f6 8b4110 25c0010000 }
            // n = 7, score = 100
            //   7606                 | jbe                 8
            //   2bc2                 | sub                 eax, edx
            //   8bf0                 | mov                 esi, eax
            //   eb02                 | jmp                 4
            //   33f6                 | xor                 esi, esi
            //   8b4110               | mov                 eax, dword ptr [ecx + 0x10]
            //   25c0010000           | and                 eax, 0x1c0

        $sequence_2 = { eb53 83ec1c 8bf4 83ec1c 8bcc 68???????? eb42 }
            // n = 7, score = 100
            //   eb53                 | jmp                 0x55
            //   83ec1c               | sub                 esp, 0x1c
            //   8bf4                 | mov                 esi, esp
            //   83ec1c               | sub                 esp, 0x1c
            //   8bcc                 | mov                 ecx, esp
            //   68????????           |                     
            //   eb42                 | jmp                 0x44

        $sequence_3 = { 51 56 8844244b ffd7 8a530e 83c448 6a01 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   56                   | push                esi
            //   8844244b             | mov                 byte ptr [esp + 0x4b], al
            //   ffd7                 | call                edi
            //   8a530e               | mov                 dl, byte ptr [ebx + 0xe]
            //   83c448               | add                 esp, 0x48
            //   6a01                 | push                1

        $sequence_4 = { 730e dc0d???????? 2bfa 03da 3bfa 7ddd 807d1700 }
            // n = 7, score = 100
            //   730e                 | jae                 0x10
            //   dc0d????????         |                     
            //   2bfa                 | sub                 edi, edx
            //   03da                 | add                 ebx, edx
            //   3bfa                 | cmp                 edi, edx
            //   7ddd                 | jge                 0xffffffdf
            //   807d1700             | cmp                 byte ptr [ebp + 0x17], 0

        $sequence_5 = { 8d4c2408 894604 c706???????? e8???????? 50 8bce e8???????? }
            // n = 7, score = 100
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   c706????????         |                     
            //   e8????????           |                     
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_6 = { 7202 8b00 2bf0 57 d1fe 56 53 }
            // n = 7, score = 100
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   2bf0                 | sub                 esi, eax
            //   57                   | push                edi
            //   d1fe                 | sar                 esi, 1
            //   56                   | push                esi
            //   53                   | push                ebx

        $sequence_7 = { 7411 397b40 730c 50 e8???????? 83c404 896b3c }
            // n = 7, score = 100
            //   7411                 | je                  0x13
            //   397b40               | cmp                 dword ptr [ebx + 0x40], edi
            //   730c                 | jae                 0xe
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   896b3c               | mov                 dword ptr [ebx + 0x3c], ebp

        $sequence_8 = { 7303 8d4da0 663b01 740c 6aff 6a00 8d4d9c }
            // n = 7, score = 100
            //   7303                 | jae                 5
            //   8d4da0               | lea                 ecx, [ebp - 0x60]
            //   663b01               | cmp                 ax, word ptr [ecx]
            //   740c                 | je                  0xe
            //   6aff                 | push                -1
            //   6a00                 | push                0
            //   8d4d9c               | lea                 ecx, [ebp - 0x64]

        $sequence_9 = { 52 e8???????? 83c40c 85c0 745d 8bc8 57 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   745d                 | je                  0x5f
            //   8bc8                 | mov                 ecx, eax
            //   57                   | push                edi

    condition:
        7 of them and filesize < 855040
}