rule win_extreme_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.extreme_rat"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68f4010000 e8???????? 833d????????00 7527 }
            // n = 4, score = 300
            //   68f4010000           | push                0x1f4
            //   e8????????           |                     
            //   833d????????00       |                     
            //   7527                 | jne                 0x29

        $sequence_1 = { e8???????? 83f801 1bc0 40 8845fb 8b45f4 0385d8feffff }
            // n = 7, score = 300
            //   e8????????           |                     
            //   83f801               | cmp                 eax, 1
            //   1bc0                 | sbb                 eax, eax
            //   40                   | inc                 eax
            //   8845fb               | mov                 byte ptr [ebp - 5], al
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   0385d8feffff         | add                 eax, dword ptr [ebp - 0x128]

        $sequence_2 = { 8bd8 53 e8???????? 83c802 83c801 83c804 50 }
            // n = 7, score = 300
            //   8bd8                 | mov                 ebx, eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c802               | or                  eax, 2
            //   83c801               | or                  eax, 1
            //   83c804               | or                  eax, 4
            //   50                   | push                eax

        $sequence_3 = { 8b45ec e8???????? 50 6801000080 e8???????? 85c0 753a }
            // n = 7, score = 300
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   50                   | push                eax
            //   6801000080           | push                0x80000001
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   753a                 | jne                 0x3c

        $sequence_4 = { 81ff00010000 75f2 33f6 33ff 8d9df0fbffff 8d85ecfaffff 8b55f4 }
            // n = 7, score = 300
            //   81ff00010000         | cmp                 edi, 0x100
            //   75f2                 | jne                 0xfffffff4
            //   33f6                 | xor                 esi, esi
            //   33ff                 | xor                 edi, edi
            //   8d9df0fbffff         | lea                 ebx, [ebp - 0x410]
            //   8d85ecfaffff         | lea                 eax, [ebp - 0x514]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_5 = { 7426 8b550c 52 6a00 }
            // n = 4, score = 300
            //   7426                 | je                  0x28
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   52                   | push                edx
            //   6a00                 | push                0

        $sequence_6 = { e8???????? 6605d107 50 a1???????? }
            // n = 4, score = 300
            //   e8????????           |                     
            //   6605d107             | add                 ax, 0x7d1
            //   50                   | push                eax
            //   a1????????           |                     

        $sequence_7 = { 56 e8???????? 8a0424 81c430020000 5f }
            // n = 5, score = 300
            //   56                   | push                esi
            //   e8????????           |                     
            //   8a0424               | mov                 al, byte ptr [esp]
            //   81c430020000         | add                 esp, 0x230
            //   5f                   | pop                 edi

        $sequence_8 = { 53 56 8bd8 8bf3 66ba5c00 8bc3 e8???????? }
            // n = 7, score = 300
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8bd8                 | mov                 ebx, eax
            //   8bf3                 | mov                 esi, ebx
            //   66ba5c00             | mov                 dx, 0x5c
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     

        $sequence_9 = { 8b3f 33f6 eb60 6683f822 7541 53 }
            // n = 6, score = 300
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   33f6                 | xor                 esi, esi
            //   eb60                 | jmp                 0x62
            //   6683f822             | cmp                 ax, 0x22
            //   7541                 | jne                 0x43
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 925696
}