rule win_fakerean_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fakerean."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fakerean"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c 6a07 05???????? 59 ba30f8ffff }
            // n = 5, score = 300
            //   83c40c               | add                 esp, 0xc
            //   6a07                 | push                7
            //   05????????           |                     
            //   59                   | pop                 ecx
            //   ba30f8ffff           | mov                 edx, 0xfffff830

        $sequence_1 = { ab ab ab ab 6a08 59 }
            // n = 6, score = 300
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   6a08                 | push                8
            //   59                   | pop                 ecx

        $sequence_2 = { ff37 ff15???????? ff45fc 837dfc04 7cb7 53 ff15???????? }
            // n = 7, score = 300
            //   ff37                 | push                dword ptr [edi]
            //   ff15????????         |                     
            //   ff45fc               | inc                 dword ptr [ebp - 4]
            //   837dfc04             | cmp                 dword ptr [ebp - 4], 4
            //   7cb7                 | jl                  0xffffffb9
            //   53                   | push                ebx
            //   ff15????????         |                     

        $sequence_3 = { 8d45e4 50 6a00 56 ff15???????? }
            // n = 5, score = 300
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_4 = { 742c 8b11 33db 83f81b 0f95c3 8d5c1b02 53 }
            // n = 7, score = 300
            //   742c                 | je                  0x2e
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   33db                 | xor                 ebx, ebx
            //   83f81b               | cmp                 eax, 0x1b
            //   0f95c3               | setne               bl
            //   8d5c1b02             | lea                 ebx, [ebx + ebx + 2]
            //   53                   | push                ebx

        $sequence_5 = { 52 50 53 51 e8???????? 3bd7 }
            // n = 6, score = 300
            //   52                   | push                edx
            //   50                   | push                eax
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   3bd7                 | cmp                 edx, edi

        $sequence_6 = { 83c11a ffb48ef0000000 50 ff15???????? 33c0 399e88040000 }
            // n = 6, score = 300
            //   83c11a               | add                 ecx, 0x1a
            //   ffb48ef0000000       | push                dword ptr [esi + ecx*4 + 0xf0]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   399e88040000         | cmp                 dword ptr [esi + 0x488], ebx

        $sequence_7 = { 83c40c 83f801 7419 57 6a3c 68???????? e8???????? }
            // n = 7, score = 300
            //   83c40c               | add                 esp, 0xc
            //   83f801               | cmp                 eax, 1
            //   7419                 | je                  0x1b
            //   57                   | push                edi
            //   6a3c                 | push                0x3c
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_8 = { c9 c21c00 55 8bec 53 56 8b7510 }
            // n = 7, score = 300
            //   c9                   | leave               
            //   c21c00               | ret                 0x1c
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]

        $sequence_9 = { ff33 ff15???????? 56 ff33 ff15???????? 897df8 8b45f0 }
            // n = 7, score = 300
            //   ff33                 | push                dword ptr [ebx]
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff33                 | push                dword ptr [ebx]
            //   ff15????????         |                     
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

    condition:
        7 of them and filesize < 4071424
}