rule win_fatal_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fatal_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fatal_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 ff15???????? 3bc7 89450c 0f8415020000 8d4b02 56 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   ff15????????         |                     
            //   3bc7                 | cmp                 eax, edi
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   0f8415020000         | je                  0x21b
            //   8d4b02               | lea                 ecx, [ebx + 2]
            //   56                   | push                esi

        $sequence_1 = { c6458265 c6458378 c6458465 885d85 c645a065 c645a167 c645a275 }
            // n = 7, score = 100
            //   c6458265             | mov                 byte ptr [ebp - 0x7e], 0x65
            //   c6458378             | mov                 byte ptr [ebp - 0x7d], 0x78
            //   c6458465             | mov                 byte ptr [ebp - 0x7c], 0x65
            //   885d85               | mov                 byte ptr [ebp - 0x7b], bl
            //   c645a065             | mov                 byte ptr [ebp - 0x60], 0x65
            //   c645a167             | mov                 byte ptr [ebp - 0x5f], 0x67
            //   c645a275             | mov                 byte ptr [ebp - 0x5e], 0x75

        $sequence_2 = { 5f 5d c3 55 8bec 81ece0060000 53 }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ece0060000         | sub                 esp, 0x6e0
            //   53                   | push                ebx

        $sequence_3 = { ff15???????? 8d857cffffff 50 e8???????? 85c0 59 7429 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8d857cffffff         | lea                 eax, [ebp - 0x84]
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   7429                 | je                  0x2b

        $sequence_4 = { eb34 8d859cfeffff 50 ff15???????? 8d859cfeffff 68???????? 50 }
            // n = 7, score = 100
            //   eb34                 | jmp                 0x36
            //   8d859cfeffff         | lea                 eax, [ebp - 0x164]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d859cfeffff         | lea                 eax, [ebp - 0x164]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_5 = { 56 ff15???????? 68???????? 56 ff15???????? 8d85a4feffff }
            // n = 6, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   68????????           |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8d85a4feffff         | lea                 eax, [ebp - 0x15c]

        $sequence_6 = { eb19 833801 7407 b800000800 eb0d 8b4004 }
            // n = 6, score = 100
            //   eb19                 | jmp                 0x1b
            //   833801               | cmp                 dword ptr [eax], 1
            //   7407                 | je                  9
            //   b800000800           | mov                 eax, 0x80000
            //   eb0d                 | jmp                 0xf
            //   8b4004               | mov                 eax, dword ptr [eax + 4]

        $sequence_7 = { 8d8568feffff 6804010000 50 56 ff15???????? 8d8568feffff 50 }
            // n = 7, score = 100
            //   8d8568feffff         | lea                 eax, [ebp - 0x198]
            //   6804010000           | push                0x104
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8d8568feffff         | lea                 eax, [ebp - 0x198]
            //   50                   | push                eax

        $sequence_8 = { 56 8b4304 8945f8 8b03 0fb74814 6683780600 8d740118 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   0fb74814             | movzx               ecx, word ptr [eax + 0x14]
            //   6683780600           | cmp                 word ptr [eax + 6], 0
            //   8d740118             | lea                 esi, [ecx + eax + 0x18]

        $sequence_9 = { c645ee68 c645ef70 885df0 ff15???????? 8bf8 3bfb 897df8 }
            // n = 7, score = 100
            //   c645ee68             | mov                 byte ptr [ebp - 0x12], 0x68
            //   c645ef70             | mov                 byte ptr [ebp - 0x11], 0x70
            //   885df0               | mov                 byte ptr [ebp - 0x10], bl
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   3bfb                 | cmp                 edi, ebx
            //   897df8               | mov                 dword ptr [ebp - 8], edi

    condition:
        7 of them and filesize < 344064
}