rule win_fatduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fatduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fatduke"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffb610020000 e8???????? 83c404 c786240200000f000000 c7862002000000000000 c6861002000000 c645fc13 }
            // n = 7, score = 200
            //   ffb610020000         | push                dword ptr [esi + 0x210]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c786240200000f000000     | mov    dword ptr [esi + 0x224], 0xf
            //   c7862002000000000000     | mov    dword ptr [esi + 0x220], 0
            //   c6861002000000       | mov                 byte ptr [esi + 0x210], 0
            //   c645fc13             | mov                 byte ptr [ebp - 4], 0x13

        $sequence_1 = { 8d411c 50 8d4dbc e8???????? c645fc01 bb01000000 53 }
            // n = 7, score = 200
            //   8d411c               | lea                 eax, [ecx + 0x1c]
            //   50                   | push                eax
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   e8????????           |                     
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   bb01000000           | mov                 ebx, 1
            //   53                   | push                ebx

        $sequence_2 = { eb02 8bc6 33d2 668910 51 8bce e8???????? }
            // n = 7, score = 200
            //   eb02                 | jmp                 4
            //   8bc6                 | mov                 eax, esi
            //   33d2                 | xor                 edx, edx
            //   668910               | mov                 word ptr [eax], dx
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_3 = { 8d8d74ffffff e8???????? 8b4d80 b8abaaaa2a 8bbd7cffffff 83c410 2bcf }
            // n = 7, score = 200
            //   8d8d74ffffff         | lea                 ecx, [ebp - 0x8c]
            //   e8????????           |                     
            //   8b4d80               | mov                 ecx, dword ptr [ebp - 0x80]
            //   b8abaaaa2a           | mov                 eax, 0x2aaaaaab
            //   8bbd7cffffff         | mov                 edi, dword ptr [ebp - 0x84]
            //   83c410               | add                 esp, 0x10
            //   2bcf                 | sub                 ecx, edi

        $sequence_4 = { e8???????? 83c418 50 8d442440 50 8d442464 50 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   50                   | push                eax
            //   8d442440             | lea                 eax, [esp + 0x40]
            //   50                   | push                eax
            //   8d442464             | lea                 eax, [esp + 0x64]
            //   50                   | push                eax

        $sequence_5 = { ffb620030000 e8???????? 83c404 c786340300000f000000 c7863003000000000000 c6862003000000 c645fc1d }
            // n = 7, score = 200
            //   ffb620030000         | push                dword ptr [esi + 0x320]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c786340300000f000000     | mov    dword ptr [esi + 0x334], 0xf
            //   c7863003000000000000     | mov    dword ptr [esi + 0x330], 0
            //   c6862003000000       | mov                 byte ptr [esi + 0x320], 0
            //   c645fc1d             | mov                 byte ptr [ebp - 4], 0x1d

        $sequence_6 = { 8bce e8???????? 33c0 c745e800000000 c745ec00000000 c745ec07000000 c745e800000000 }
            // n = 7, score = 200
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   c745ec07000000       | mov                 dword ptr [ebp - 0x14], 7
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0

        $sequence_7 = { e9???????? 8b7508 8d442414 6880000000 6a00 50 32db }
            // n = 7, score = 200
            //   e9????????           |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   6880000000           | push                0x80
            //   6a00                 | push                0
            //   50                   | push                eax
            //   32db                 | xor                 bl, bl

        $sequence_8 = { c786340300000f000000 c7863003000000000000 c6862003000000 c645fc1f 83be1c03000010 720e ffb608030000 }
            // n = 7, score = 200
            //   c786340300000f000000     | mov    dword ptr [esi + 0x334], 0xf
            //   c7863003000000000000     | mov    dword ptr [esi + 0x330], 0
            //   c6862003000000       | mov                 byte ptr [esi + 0x320], 0
            //   c645fc1f             | mov                 byte ptr [ebp - 4], 0x1f
            //   83be1c03000010       | cmp                 dword ptr [esi + 0x31c], 0x10
            //   720e                 | jb                  0x10
            //   ffb608030000         | push                dword ptr [esi + 0x308]

        $sequence_9 = { ff7728 e8???????? 83c404 c7473c0f000000 c7473800000000 c6472800 c645fc00 }
            // n = 7, score = 200
            //   ff7728               | push                dword ptr [edi + 0x28]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c7473c0f000000       | mov                 dword ptr [edi + 0x3c], 0xf
            //   c7473800000000       | mov                 dword ptr [edi + 0x38], 0
            //   c6472800             | mov                 byte ptr [edi + 0x28], 0
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0

    condition:
        7 of them and filesize < 9012224
}