rule win_finteam_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.finteam"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 83c305 8b45fc 8918 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c305               | add                 ebx, 5
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8918                 | mov                 dword ptr [eax], ebx

        $sequence_1 = { 8b04b550f11813 50 8bc7 e8???????? 50 e8???????? }
            // n = 6, score = 100
            //   8b04b550f11813       | mov                 eax, dword ptr [esi*4 + 0x1318f150]
            //   50                   | push                eax
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { 807b4800 750d 837b1800 7507 c74318e02f1413 }
            // n = 5, score = 100
            //   807b4800             | cmp                 byte ptr [ebx + 0x48], 0
            //   750d                 | jne                 0xf
            //   837b1800             | cmp                 dword ptr [ebx + 0x18], 0
            //   7507                 | jne                 9
            //   c74318e02f1413       | mov                 dword ptr [ebx + 0x18], 0x13142fe0

        $sequence_3 = { 6a00 68???????? a1???????? e8???????? 50 6a00 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   68????????           |                     
            //   a1????????           |                     
            //   e8????????           |                     
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_4 = { 833c9d70171913ff 75f0 8d45fc 8b5508 e8???????? 8b45fc }
            // n = 6, score = 100
            //   833c9d70171913ff     | cmp                 dword ptr [ebx*4 + 0x13191770], -1
            //   75f0                 | jne                 0xfffffff2
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_5 = { 8b45b4 e8???????? 50 68???????? 6a00 e8???????? 8d45b0 }
            // n = 7, score = 100
            //   8b45b4               | mov                 eax, dword ptr [ebp - 0x4c]
            //   e8????????           |                     
            //   50                   | push                eax
            //   68????????           |                     
            //   6a00                 | push                0
            //   e8????????           |                     
            //   8d45b0               | lea                 eax, [ebp - 0x50]

        $sequence_6 = { 13b014151380 1415 13b41c1513641c 15139cb415 }
            // n = 4, score = 100
            //   13b014151380         | adc                 esi, dword ptr [eax - 0x7feceaec]
            //   1415                 | adc                 al, 0x15
            //   13b41c1513641c       | adc                 esi, dword ptr [esp + ebx + 0x1c641315]
            //   15139cb415           | adc                 eax, 0x15b49c13

        $sequence_7 = { 3598141391 98 1413 c8981413 c8981413 32991413494e 46 }
            // n = 7, score = 100
            //   3598141391           | xor                 eax, 0x91131498
            //   98                   | cwde                
            //   1413                 | adc                 al, 0x13
            //   c8981413             | enter               0x1498, 0x13
            //   c8981413             | enter               0x1498, 0x13
            //   32991413494e         | xor                 bl, byte ptr [ecx + 0x4e491314]
            //   46                   | inc                 esi

        $sequence_8 = { e8???????? 8b55c0 b8???????? e8???????? 6a00 6a00 68???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b55c0               | mov                 edx, dword ptr [ebp - 0x40]
            //   b8????????           |                     
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_9 = { 7518 33c0 8a4318 8b04857cfb1813 }
            // n = 4, score = 100
            //   7518                 | jne                 0x1a
            //   33c0                 | xor                 eax, eax
            //   8a4318               | mov                 al, byte ptr [ebx + 0x18]
            //   8b04857cfb1813       | mov                 eax, dword ptr [eax*4 + 0x1318fb7c]

    condition:
        7 of them and filesize < 776192
}
